/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.hackshop.ultimate_unicorn.mobs.model.ModelData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;

public class ModelDataEditor {
    public static ConcurrentHashMap<String, ModelData> modelData = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, ConcurrentHashMap<String, ModelData>> checkpoints = new ConcurrentHashMap();

    public static void checkpoint(String name) {
        ConcurrentHashMap<String, ModelData> newMap = new ConcurrentHashMap<String, ModelData>();
        for (Map.Entry<String, ModelData> e : modelData.entrySet()) {
            newMap.put(e.getKey(), new ModelData(e.getValue()));
        }
        checkpoints.put(name, newMap);
    }

    public static void restore(String name) {
        ConcurrentHashMap<String, ModelData> sourceMap = checkpoints.get(name);
        if (sourceMap != null) {
            modelData.clear();
            for (Map.Entry<String, ModelData> e : sourceMap.entrySet()) {
                modelData.put(e.getKey(), new ModelData(e.getValue()));
            }
        }
    }

    public static String makeCodeSnippet(String name, ModelData data) {
        return "this." + name + " = new ModelDebugger(parent, new ModelRenderer(parent, " + data.texOffsetX + ", " + data.texOffsetY + "), \"" + name + "\");\nthis." + name + ".addBox(" + data.offsetX + "F, " + data.offsetY + "F, " + data.offsetZ + "F, " + data.width + ", " + data.height + ", " + data.depth + ");\nthis." + name + ".setRotationPoint(" + data.rotPointX + "F, " + data.rotPointY + "F, " + data.rotPointZ + "F);\n((ModelDebugger) this." + name + ").setRotation(" + data.rotX + "F, " + data.rotY + "F, " + data.rotZ + "F);\n";
    }

    public static String makeRealCodeSnippet(String name, ModelData data) {
        return "this." + name + " = new ModelRenderer(parent, " + data.texOffsetX + ", " + data.texOffsetY + ");\nthis." + name + ".addBox(" + data.offsetX + "F, " + data.offsetY + "F, " + data.offsetZ + "F, " + data.width + ", " + data.height + ", " + data.depth + ");\nthis." + name + ".setRotationPoint(" + data.rotPointX + "F, " + data.rotPointY + "F, " + data.rotPointZ + "F);\nparent.setBoxRotation(this." + name + ", " + data.rotX + "F, " + data.rotY + "F, " + data.rotZ + "F);\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        StringBuilder codeBuilder = new StringBuilder();
        for (Map.Entry<String, ModelData> entry : modelData.entrySet()) {
            codeBuilder.append(ModelDataEditor.makeCodeSnippet(entry.getKey(), entry.getValue()));
        }
        StringBuilder codeBuilder2 = new StringBuilder();
        for (Map.Entry<String, ModelData> entry : modelData.entrySet()) {
            codeBuilder2.append(ModelDataEditor.makeRealCodeSnippet(entry.getKey(), entry.getValue()));
        }
        File file = new File(Minecraft.func_71410_x().field_71412_D, "model-debug.txt");
        File file2 = new File(Minecraft.func_71410_x().field_71412_D, "model-debug-code.txt");
        File file3 = new File(Minecraft.func_71410_x().field_71412_D, "model-real-code.txt");
        Gson builder = new GsonBuilder().setPrettyPrinting().create();
        String str = builder.toJson(modelData);
        System.out.println("JSON: " + str);
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(str);
            writer.close();
            writer = new FileWriter(file2);
            writer.write(codeBuilder.toString());
            writer.close();
            writer = new FileWriter(file3);
            writer.write(codeBuilder2.toString());
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void load() {
        File file1 = new File(Minecraft.func_71410_x().field_71412_D, "model-debug.txt");
        try {
            BufferedReader r = new BufferedReader(new FileReader(file1));
            StringBuilder strBuilder = new StringBuilder();
            String str = r.readLine();
            while (str != null) {
                strBuilder.append(str);
                str = r.readLine();
            }
            if (strBuilder == null || strBuilder.toString().trim().equals("")) {
                System.out.println("Loaded JSON was empty!");
                return;
            }
            System.out.println("Loaded JSON string: " + strBuilder.toString());
            Type type = new TypeToken<Map<String, ModelData>>(){}.getType();
            Map map = (Map)new Gson().fromJson(strBuilder.toString(), type);
            modelData.clear();
            for (Map.Entry e : map.entrySet()) {
                modelData.put((String)e.getKey(), new ModelData((ModelData)e.getValue()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void update(String target, String command, String x, String y, String z) {
        ModelData modelData = ModelDataEditor.modelData.get(target);
        if (modelData == null) {
            System.out.println("No target model named " + target);
            return;
        }
        if (command.equals("setSize")) {
            modelData.width = Integer.parseInt(x);
            modelData.height = Integer.parseInt(y);
            modelData.depth = Integer.parseInt(z);
        } else if (command.equals("setPos") || command.equals("setOffset")) {
            modelData.offsetX = Float.parseFloat(x);
            modelData.offsetY = Float.parseFloat(y);
            modelData.offsetZ = Float.parseFloat(z);
        } else if (command.equals("setRotp")) {
            modelData.rotPointX = Float.parseFloat(x);
            modelData.rotPointY = Float.parseFloat(y);
            modelData.rotPointZ = Float.parseFloat(z);
        } else if (command.equals("setRot")) {
            modelData.rotX = Float.parseFloat(x) / 180.0f * 3.141529f;
            modelData.rotY = Float.parseFloat(y) / 180.0f * 3.141529f;
            modelData.rotZ = Float.parseFloat(z) / 180.0f * 3.141529f;
        } else if (command.equals("print")) {
            System.out.println("MODEL DATA: ");
            System.out.println(target + ":");
            System.out.println(modelData);
        }
    }
}

