/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hackshop.ultimate_unicorn.BreakBlockMessage;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.custom.CustomHorseInfo;
import com.hackshop.ultimate_unicorn.custom.HorseLayeredTexture;
import com.hackshop.ultimate_unicorn.custom.LayeredTexture;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.model.ModelMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.renderer.HorseArmorLayer;
import com.hackshop.ultimate_unicorn.network.PacketHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.MobEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagicalHorseRenderer
extends AbstractHorseRenderer<EntityMagicalHorse, ModelMagicalHorse<EntityMagicalHorse>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final ResourceLocation rainbowBeamTexture = new ResourceLocation("ultimate_unicorn_mod:textures/entity/rainbow_beam.png");
    private BlockRayTraceResult lastTarget = null;
    private int lastDamage = 0;
    private int lastDamageCounter = 0;
    private List<BeaconTileEntity.BeamSegment> beamSections = Lists.newArrayList();

    public MagicalHorseRenderer(EntityRendererManager p_i47205_1_) {
        super(p_i47205_1_, new ModelMagicalHorse(0.0f), 1.1f);
        this.func_177094_a(new HorseArmorLayer((IEntityRenderer<EntityMagicalHorse, ModelMagicalHorse<EntityMagicalHorse>>)this));
        float[] color = new float[]{1.0f, 1.0f, 1.0f};
        this.beamSections.add(new BeaconTileEntity.BeamSegment(color));
        this.beamSections.add(new BeaconTileEntity.BeamSegment(color));
        this.beamSections.add(new BeaconTileEntity.BeamSegment(color));
        this.beamSections.add(new BeaconTileEntity.BeamSegment(color));
        this.beamSections.add(new BeaconTileEntity.BeamSegment(color));
    }

    public ResourceLocation getTextureLocation(EntityMagicalHorse unicorn) {
        String textureString = unicorn.getHorseTexture();
        ResourceLocation texResourceLoc = LAYERED_LOCATION_CACHE.get(textureString);
        if (texResourceLoc == null) {
            CustomHorseInfo chi;
            String texResName = "";
            ITextComponent customName = unicorn.func_200201_e();
            boolean done = false;
            if (customName != null && (chi = CommonProxy.customHorseData.get(customName.getString().toLowerCase())) != null && (chi.isReady() || chi.isInMod())) {
                texResName = chi.texture;
                texResourceLoc = new ResourceLocation(textureString);
                if (chi.isInMod()) {
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(texResourceLoc, (Texture)new LayeredTexture(unicorn.getVariantTexturePaths()));
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(texResourceLoc, (Texture)new HorseLayeredTexture(chi, unicorn.getVariantTexturePaths()));
                }
                done = true;
            }
            if (!done) {
                texResourceLoc = new ResourceLocation(textureString);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(texResourceLoc, (Texture)new LayeredTexture(unicorn.getVariantTexturePaths()));
            }
            LAYERED_LOCATION_CACHE.put(textureString, texResourceLoc);
        }
        return texResourceLoc;
    }

    public void render(EntityMagicalHorse unicorn, float p_225623_2_, float p_225623_3_, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int p_225623_6_) {
        if (unicorn.canDive()) {
            if (unicorn.isDiving()) {
                float dir = unicorn.field_70177_z * 0.0174533f;
                Vector3f vec = new Vector3f(MathHelper.func_76134_b((float)dir), 0.0f, MathHelper.func_76126_a((float)dir));
                matrixStack.func_227863_a_(vec.func_229187_a_(40.0f));
            }
            GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
            if (Minecraft.func_71410_x().field_71439_g.equals((Object)unicorn.func_184179_bs())) {
                Vector3f vec;
                float dir;
                Vector3f vec2;
                if (gameSettings.field_74370_x.func_151470_d() && !unicorn.func_233570_aj_()) {
                    float perp = (unicorn.field_70177_z + 90.0f) * 0.0174533f;
                    vec2 = new Vector3f(MathHelper.func_76134_b((float)perp), 0.0f, MathHelper.func_76126_a((float)perp));
                    dir = unicorn.field_70177_z * 0.0174533f;
                    vec = new Vector3f(MathHelper.func_76134_b((float)dir), 0.0f, MathHelper.func_76126_a((float)dir));
                    vec.func_195898_a(0.3f);
                    matrixStack.func_227861_a_((double)(-vec.func_195899_a()), (double)(-vec.func_195900_b()), (double)(-vec.func_195902_c()));
                    matrixStack.func_227863_a_(vec2.func_229187_a_(-10.0f));
                }
                if (gameSettings.field_74366_z.func_151470_d() && !unicorn.func_233570_aj_()) {
                    float perp = (unicorn.field_70177_z + 90.0f) * 0.0174533f;
                    vec2 = new Vector3f(MathHelper.func_76134_b((float)perp), 0.0f, MathHelper.func_76126_a((float)perp));
                    dir = unicorn.field_70177_z * 0.0174533f;
                    vec = new Vector3f(MathHelper.func_76134_b((float)dir), 0.0f, MathHelper.func_76126_a((float)dir));
                    vec.func_195898_a(0.3f);
                    matrixStack.func_227861_a_((double)vec.func_195899_a(), (double)vec.func_195900_b(), (double)vec.func_195902_c());
                    matrixStack.func_227863_a_(vec2.func_229187_a_(10.0f));
                }
            }
        }
        super.func_225623_a_((MobEntity)unicorn, p_225623_2_, p_225623_3_, matrixStack, renderTypeBuffer, p_225623_6_);
        if (unicorn.getHideType() == 5 && unicorn.getCharge() && unicorn.powerSettings.isEnabled(EntityMagicalHorse.OrderedPower.RAINBOW_BEAM)) {
            long i = unicorn.field_70170_p.func_82737_E();
            List<BeaconTileEntity.BeamSegment> list = this.beamSections;
            int j = 0;
            float dist = this.doBeamEffects(unicorn, i);
            for (int k = 0; k < list.size(); ++k) {
                BeaconTileEntity.BeamSegment beacontileentity$beamsegment = list.get(k);
                MagicalHorseRenderer.renderBeaconBeam(unicorn, matrixStack, renderTypeBuffer, p_225623_3_, i, j, (int)dist, beacontileentity$beamsegment.func_177263_b());
                j += beacontileentity$beamsegment.func_177264_c();
            }
        }
    }

    private float doBeamEffects(EntityMagicalHorse horse, float tickOffset) {
        float dist = 60.0f;
        RayTraceResult target = horse.rayTraceHorn(60.0, tickOffset);
        Vector3d pos = null;
        if (null != target) {
            switch (target.func_216346_c()) {
                case BLOCK: {
                    BlockRayTraceResult brtr = (BlockRayTraceResult)target;
                    BlockPos targetBlockPos = brtr.func_216350_a();
                    dist = MathHelper.func_76133_a((double)horse.func_70092_e(targetBlockPos.func_177958_n(), targetBlockPos.func_177956_o(), targetBlockPos.func_177952_p())) + 0.1f;
                    pos = brtr.func_216347_e();
                    if (this.lastTarget != null && targetBlockPos.equals((Object)this.lastTarget.func_216350_a()) && dist < 21.0f) {
                        float destroySpeed = horse.field_70170_p.func_180495_p(targetBlockPos).func_185887_b(null, null);
                        if (destroySpeed < 2.1f) {
                            ++this.lastDamageCounter;
                            float limit = 2.7f * destroySpeed;
                            if ((float)this.lastDamageCounter > limit) {
                                this.lastDamageCounter = 0;
                                ++this.lastDamage;
                                if (this.lastDamage > 9) {
                                    PacketHandler.sendToServer(new BreakBlockMessage(targetBlockPos.func_177958_n(), targetBlockPos.func_177956_o(), targetBlockPos.func_177952_p()));
                                }
                            }
                        }
                    } else {
                        this.lastDamageCounter = 0;
                        this.lastDamage = 0;
                    }
                    horse.field_70170_p.func_175715_c(horse.func_145782_y(), targetBlockPos, this.lastDamage);
                    this.lastTarget = brtr;
                    break;
                }
                case ENTITY: {
                    EntityRayTraceResult ertr = (EntityRayTraceResult)target;
                    dist = horse.func_70032_d(ertr.func_216348_a());
                    pos = ertr.func_216347_e();
                    break;
                }
            }
        }
        if (null != pos) {
            Random rand = horse.field_70170_p.field_73012_v;
            for (int i = 0; i < 1; ++i) {
                double d0 = rand.nextGaussian();
                double d1 = rand.nextGaussian();
                double d2 = rand.nextGaussian();
                double d3 = rand.nextGaussian();
                double d4 = rand.nextGaussian();
                double d5 = rand.nextGaussian();
                horse.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, pos.field_72450_a + d0, pos.field_72448_b + d1, pos.field_72449_c + d2, d3, d4, d5);
            }
        }
        return dist;
    }

    protected void scale(EntityMagicalHorse horse, MatrixStack matrixStack, float partialTickTime) {
        if (horse.hasDestrierBody()) {
            matrixStack.func_227862_a_(1.8f, 1.8f, 1.8f);
        }
    }

    @Nullable
    protected RenderType getRenderType(EntityMagicalHorse unicorn, boolean visible, boolean invisibleExceptToPlayer, boolean glowing) {
        ResourceLocation resourcelocation = this.getTextureLocation(unicorn);
        if (invisibleExceptToPlayer) {
            return RenderType.func_239268_f_((ResourceLocation)resourcelocation);
        }
        if (visible) {
            return RenderType.func_239268_f_((ResourceLocation)resourcelocation);
        }
        return glowing ? RenderType.func_228654_j_((ResourceLocation)resourcelocation) : null;
    }

    private static void renderBeaconBeam(EntityMagicalHorse unicorn, MatrixStack matrixStack, IRenderTypeBuffer buffer, float p_228841_2_, long i, int j, int k, float[] color) {
        MagicalHorseRenderer.renderBeaconBeam(unicorn, matrixStack, buffer, rainbowBeamTexture, p_228841_2_, 1.0f, i, j, k, color, 0.2f, 0.25f);
    }

    public static void renderBeaconBeam(EntityMagicalHorse unicorn, MatrixStack matrixStack, IRenderTypeBuffer buffer, ResourceLocation texture, float p_228842_3_, float p_228842_4_, long iArg, int jArg, int kArg, float[] color, float insideBeamScaler, float outsideBeamScaler) {
        float i = jArg + kArg;
        matrixStack.func_227860_a_();
        float f = (float)Math.floorMod(iArg, 40L) + p_228842_3_;
        float f1 = kArg < 0 ? f : -f;
        float f2 = MathHelper.func_226164_h_((float)(f1 * 0.2f - (float)MathHelper.func_76141_d((float)(f1 * 0.1f))));
        float f3 = color[0];
        float f4 = color[1];
        float f5 = color[2];
        matrixStack.func_227860_a_();
        float beamHeight = 1.2f;
        float beamForward = 0.8f;
        if (unicorn.hasDestrierBody()) {
            beamHeight = 2.1f;
            beamForward = 2.3f;
        }
        matrixStack.func_227861_a_(0.0, (double)beamForward, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f - unicorn.field_70177_z));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f * 2.25f - 45.0f));
        matrixStack.func_227861_a_((double)beamHeight, 0.0, 0.0);
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -insideBeamScaler;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = -insideBeamScaler;
        float f13 = 0.0f;
        float f14 = 1.0f;
        float f15 = -1.0f + f2;
        float f16 = (float)kArg * p_228842_4_ * (0.5f / insideBeamScaler) + f15;
        float scaleAmount = (i - beamForward * 6.0f) / i;
        matrixStack.func_227862_a_(scaleAmount, 1.0f, 1.0f);
        MagicalHorseRenderer.renderPart(matrixStack, buffer.getBuffer(RenderType.func_228637_a_((ResourceLocation)texture, (boolean)false)), f3, f4, f5, 1.0f, jArg, i, 0.0f, insideBeamScaler, insideBeamScaler, 0.0f, f9, 0.0f, 0.0f, f12, 0.0f, 1.0f, f16, f15);
        matrixStack.func_227865_b_();
        f6 = -outsideBeamScaler;
        float f7 = -outsideBeamScaler;
        f8 = -outsideBeamScaler;
        f9 = -outsideBeamScaler;
        f13 = 0.0f;
        f14 = 1.0f;
        f15 = -1.0f + f2;
        f16 = (float)kArg * p_228842_4_ + f15;
        matrixStack.func_227861_a_(0.0, (double)beamForward, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f - unicorn.field_70177_z));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f * 2.25f - 45.0f));
        matrixStack.func_227861_a_((double)beamHeight, 0.0, 0.0);
        matrixStack.func_227862_a_(scaleAmount, 1.0f, 1.0f);
        MagicalHorseRenderer.renderPart(matrixStack, buffer.getBuffer(RenderType.func_228637_a_((ResourceLocation)texture, (boolean)true)), f3, f4, f5, 0.125f, jArg, i, f6, f7, outsideBeamScaler, f8, f9, outsideBeamScaler, outsideBeamScaler, outsideBeamScaler, 0.0f, 1.0f, f16, f15);
        matrixStack.func_227865_b_();
    }

    private static void renderPart(MatrixStack p_228840_0_, IVertexBuilder vertexBuilder, float red, float green, float blue, float alpha, float yInt0, float yInt1, float p_228840_8_, float p_228840_9_, float p_228840_10_, float p_228840_11_, float p_228840_12_, float p_228840_13_, float p_228840_14_, float p_228840_15_, float p_228840_16_, float p_228840_17_, float p_228840_18_, float p_228840_19_) {
        MatrixStack.Entry matrixstack$entry = p_228840_0_.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        MagicalHorseRenderer.renderQuad(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, yInt0, yInt1, p_228840_8_, p_228840_9_, p_228840_10_, p_228840_11_, p_228840_16_, p_228840_17_, p_228840_18_, p_228840_19_);
        MagicalHorseRenderer.renderQuad(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, yInt0, yInt1, p_228840_14_, p_228840_15_, p_228840_12_, p_228840_13_, p_228840_16_, p_228840_17_, p_228840_18_, p_228840_19_);
        MagicalHorseRenderer.renderQuad(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, yInt0, yInt1, p_228840_10_, p_228840_11_, p_228840_14_, p_228840_15_, p_228840_16_, p_228840_17_, p_228840_18_, p_228840_19_);
        MagicalHorseRenderer.renderQuad(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, yInt0, yInt1, p_228840_12_, p_228840_13_, p_228840_8_, p_228840_9_, p_228840_16_, p_228840_17_, p_228840_18_, p_228840_19_);
    }

    private static void renderQuad(Matrix4f matrix4f, Matrix3f matrix3f, IVertexBuilder vertexBuilder, float red, float green, float blue, float alpha, float yInt0, float yInt1, float x0, float z0, float x1, float z1, float u0, float u1, float v0, float v1) {
        MagicalHorseRenderer.addVertex(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, x0, yInt1, z0, u1, v0);
        MagicalHorseRenderer.addVertex(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, x0, yInt0, z0, u1, v1);
        MagicalHorseRenderer.addVertex(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, x1, yInt0, z1, u0, v1);
        MagicalHorseRenderer.addVertex(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, x1, yInt1, z1, u0, v0);
    }

    private static void addVertex(Matrix4f matrix4f, Matrix3f matrix3f, IVertexBuilder vertexBuilder, float red, float green, float blue, float alpha, float yInt, float x, float z, float u, float v) {
        vertexBuilder.func_227888_a_(matrix4f, x, yInt, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public boolean shouldRenderOffScreen(BeaconTileEntity p_188185_1_) {
        return true;
    }
}

