/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityThrownItem
extends ItemEntity {
    protected boolean inGround;
    private String throwerName;
    private int ticksInAir;
    private static final String __OBFID = "CL_00001723";
    private int damage = 2;
    public UUID throwingEntity;
    private int knockbackStrength = 1;

    public EntityThrownItem(World worldIn, double x, double y, double z, ItemStack stack, int damage) {
        super(worldIn, x, y, z, stack);
        this.func_70107_b(x, y, z);
        this.damage = damage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isInRangeToRenderDist(double distance) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    protected void func_70088_a() {
    }

    protected EntityThrownItem(EntityType<? extends ItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityThrownItem(World worldIn, LivingEntity throwerIn, ItemStack stack, int damage) {
        this(worldIn, throwerIn.func_226277_ct_(), throwerIn.func_226280_cw_() - (double)0.1f, throwerIn.func_226281_cx_(), stack, damage);
        this.setThrower((Entity)throwerIn);
    }

    protected float getVelocity() {
        return 1.5f;
    }

    protected float getInaccuracy() {
        return 0.0f;
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.func_213293_j(x *= (double)velocity, y *= (double)velocity, z *= (double)velocity);
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
    }

    public void setThrower(@Nullable Entity entityIn) {
        this.throwingEntity = entityIn == null ? null : entityIn.func_110124_au();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213293_j(double x, double y, double z) {
        super.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70177_z == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        EntityRayTraceResult entityraytraceresult;
        Vector3d vec3d3;
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70071_h_();
        boolean flag = false;
        Vector3d vec3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70177_z == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntityThrownItem.func_213296_b((Vector3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70177_z = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            Vector3d vec3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vec3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        ++this.ticksInAir;
        Vector3d vec3d2 = this.func_213303_ch();
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d2, vec3d3 = vec3d2.func_178787_e(vec3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vec3d3 = raytraceresult.func_216347_e();
        }
        if ((entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
            Entity entity1 = this.getThrowerEntity();
            if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                raytraceresult = null;
                entityraytraceresult = null;
            }
        }
        raytraceresult = null;
        vec3d = this.func_213322_ci();
        double d3 = vec3d.field_72450_a;
        double d4 = vec3d.field_72448_b;
        double d0 = vec3d.field_72449_c;
        double d5 = this.func_226277_ct_() + d3;
        double d1 = this.func_226278_cu_() + d4;
        double d2 = this.func_226281_cx_() + d0;
        float f1 = MathHelper.func_76133_a((double)EntityThrownItem.func_213296_b((Vector3d)vec3d));
        this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70177_z < -180.0f) {
            this.field_70177_z -= 360.0f;
        }
        while (this.field_70177_z - this.field_70177_z >= 180.0f) {
            this.field_70177_z += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70177_z, (float)this.field_70177_z);
        float f2 = 0.99f;
        float f3 = 0.05f;
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f4 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
            f2 = this.getWaterDrag();
        }
        this.func_213317_d(vec3d.func_186678_a((double)f2));
        if (!this.func_189652_ae() && !flag) {
            Vector3d vec3d4 = this.func_213322_ci();
            this.func_213293_j(vec3d4.field_72450_a, vec3d4.field_72448_b - (double)0.05f, vec3d4.field_72449_c);
        }
        this.func_70107_b(d5, d1, d2);
        this.func_145775_I();
    }

    protected float getWaterDrag() {
        return 0.9f;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.throwingEntity != null) {
            compound.func_186854_a("OwnerUUID", this.throwingEntity);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("OwnerUUID")) {
            this.throwingEntity = compound.func_186857_a("OwnerUUID");
        }
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_241845_aY() && (p_213871_1_ != this.getThrowerEntity() || this.ticksInAir >= 5));
    }

    protected void onEntityHit(EntityRayTraceResult p_213868_1_) {
        DamageSource damagesource;
        Entity entity = p_213868_1_.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)Math.max((double)f * (double)this.damage, 0.0));
        Entity entity1 = this.getThrowerEntity();
        if (entity1 == null) {
            damagesource = new IndirectEntityDamageSource("thrown item", (Entity)this, (Entity)this).func_76349_b();
        } else {
            damagesource = new IndirectEntityDamageSource("thrown item", (Entity)this, entity1).func_76349_b();
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        boolean flag = entity.func_200600_R() == EntityType.field_200803_q;
        int j = entity.func_223314_ad();
        if (this.func_70027_ad() && !flag) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vector3d vec3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockbackStrength > 0 && (vec3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vec3d.field_72450_a, 0.1, vec3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.itemHit(livingentity);
            }
            this.func_70106_y();
        } else {
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70177_z += 180.0f;
            this.ticksInAir = 0;
        }
    }

    protected void itemHit(LivingEntity living) {
    }

    public void setKnockbackStrength(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    @Nullable
    public Entity getThrowerEntity() {
        return this.throwingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.throwingEntity) : null;
    }
}

