/*
 * Decompiled with CFR 0.152.
 */
package uushadowio.gsonfire;

import com.google.gson.TypeAdapter;
import java.util.Date;
import java.util.TimeZone;
import uushadowio.gsonfire.gson.DateRFC3339TypeAdapter;
import uushadowio.gsonfire.gson.DateUnixtimeMillisTypeAdapter;
import uushadowio.gsonfire.gson.DateUnixtimeSecondsTypeAdapter;
import uushadowio.gsonfire.gson.NullableTypeAdapter;

public enum DateSerializationPolicy {
    unixTimeMillis{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateUnixtimeMillisTypeAdapter(true));
        }
    }
    ,
    unixTimeSeconds{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateUnixtimeSecondsTypeAdapter(true));
        }
    }
    ,
    unixTimePositiveMillis{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateUnixtimeMillisTypeAdapter(false));
        }
    }
    ,
    unixTimePositiveSeconds{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateUnixtimeSecondsTypeAdapter(false));
        }
    }
    ,
    rfc3339{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateRFC3339TypeAdapter(serializeTimezone, true));
        }
    }
    ,
    rfc3339Date{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateRFC3339TypeAdapter(serializeTimezone, false));
        }
    };


    abstract TypeAdapter<Date> createTypeAdapter(TimeZone var1);
}

