/*
 * Decompiled with CFR 0.152.
 */
package uushadowio.gsonfire.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Set;
import uushadowio.gsonfire.ClassConfig;
import uushadowio.gsonfire.TypeSelector;
import uushadowio.gsonfire.gson.NullableTypeAdapter;
import uushadowio.gsonfire.util.JsonUtils;

public class TypeSelectorTypeAdapterFactory<T>
implements TypeAdapterFactory {
    private final ClassConfig<T> classConfig;
    private final Set<TypeToken> alreadyResolvedTypeTokensRegistry;

    public TypeSelectorTypeAdapterFactory(ClassConfig<T> classConfig, Set<TypeToken> alreadyResolvedTypeTokensRegistry) {
        this.classConfig = classConfig;
        this.alreadyResolvedTypeTokensRegistry = alreadyResolvedTypeTokensRegistry;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (this.alreadyResolvedTypeTokensRegistry.contains(type)) {
            return null;
        }
        if (this.classConfig.getConfiguredClass().isAssignableFrom(type.getRawType())) {
            NullableTypeAdapter fireTypeAdapter = new NullableTypeAdapter(new TypeSelectorTypeAdapter(type.getRawType(), this.classConfig.getTypeSelector(), gson));
            return fireTypeAdapter;
        }
        return null;
    }

    private class TypeSelectorTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Class superClass;
        private final TypeSelector typeSelector;
        private final Gson gson;

        private TypeSelectorTypeAdapter(Class superClass, TypeSelector typeSelector, Gson gson) {
            this.superClass = superClass;
            this.typeSelector = typeSelector;
            this.gson = gson;
        }

        public void write(JsonWriter out, T value) throws IOException {
            TypeAdapter otherTypeAdapter = this.gson.getDelegateAdapter((TypeAdapterFactory)TypeSelectorTypeAdapterFactory.this, TypeToken.get(value.getClass()));
            otherTypeAdapter.write(out, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T read(JsonReader in) throws IOException {
            TypeAdapter otherTypeAdapter;
            JsonElement json = new JsonParser().parse(in);
            Class deserialize = this.typeSelector.getClassForElement(json);
            if (deserialize == null) {
                deserialize = this.superClass;
            }
            TypeToken typeToken = TypeToken.get(deserialize);
            TypeSelectorTypeAdapterFactory.this.alreadyResolvedTypeTokensRegistry.add(typeToken);
            try {
                otherTypeAdapter = deserialize != this.superClass ? this.gson.getAdapter(typeToken) : this.gson.getDelegateAdapter((TypeAdapterFactory)TypeSelectorTypeAdapterFactory.this, typeToken);
            }
            finally {
                TypeSelectorTypeAdapterFactory.this.alreadyResolvedTypeTokensRegistry.remove(typeToken);
            }
            return JsonUtils.fromJsonTree(otherTypeAdapter, in, json);
        }
    }
}

