/*
 * Decompiled with CFR 0.152.
 */
package uushadowio.gsonfire.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class JsonUtils {
    private JsonUtils() {
    }

    public static JsonElement deepCopy(JsonElement from) {
        if (from.isJsonObject()) {
            JsonObject result = new JsonObject();
            for (Map.Entry entry : from.getAsJsonObject().entrySet()) {
                result.add((String)entry.getKey(), JsonUtils.deepCopy((JsonElement)entry.getValue()));
            }
            return result;
        }
        if (from.isJsonArray()) {
            JsonArray result = new JsonArray();
            for (JsonElement element : from.getAsJsonArray()) {
                result.add(element);
            }
            return result;
        }
        if (from.isJsonPrimitive()) {
            return from;
        }
        if (from.isJsonNull()) {
            return from;
        }
        return JsonNull.INSTANCE;
    }

    public static JsonElement toJsonTree(TypeAdapter typeAdapter, JsonWriter optionsFrom, Object value) throws IOException {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        jsonTreeWriter.setLenient(optionsFrom.isLenient());
        jsonTreeWriter.setHtmlSafe(optionsFrom.isHtmlSafe());
        jsonTreeWriter.setSerializeNulls(optionsFrom.getSerializeNulls());
        typeAdapter.write((JsonWriter)jsonTreeWriter, value);
        return jsonTreeWriter.get();
    }

    public static <T> T fromJsonTree(TypeAdapter<T> typeAdapter, JsonReader originalReader, JsonElement element) throws IOException {
        JsonTreeReader jsonTreeReader = new JsonTreeReader(element);
        jsonTreeReader.setLenient(originalReader.isLenient());
        return (T)typeAdapter.read((JsonReader)jsonTreeReader);
    }
}

