/*
 * Decompiled with CFR 0.152.
 */
package uushadoworg.joda.time.convert;

import uushadoworg.joda.time.Chronology;
import uushadoworg.joda.time.DateTimeUtils;
import uushadoworg.joda.time.DateTimeZone;
import uushadoworg.joda.time.PeriodType;
import uushadoworg.joda.time.ReadablePartial;
import uushadoworg.joda.time.chrono.ISOChronology;
import uushadoworg.joda.time.convert.Converter;
import uushadoworg.joda.time.format.DateTimeFormatter;

public abstract class AbstractConverter
implements Converter {
    protected AbstractConverter() {
    }

    public long getInstantMillis(Object object, Chronology chronology) {
        return DateTimeUtils.currentTimeMillis();
    }

    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        return ISOChronology.getInstance(dateTimeZone);
    }

    public Chronology getChronology(Object object, Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology) {
        long l = this.getInstantMillis(object, chronology);
        return chronology.get(readablePartial, l);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        return this.getPartialValues(readablePartial, object, chronology);
    }

    public PeriodType getPeriodType(Object object) {
        return PeriodType.standard();
    }

    public boolean isReadableInterval(Object object, Chronology chronology) {
        return false;
    }

    public String toString() {
        return "Converter[" + (this.getSupportedType() == null ? "null" : this.getSupportedType().getName()) + "]";
    }
}

