/*
 * Decompiled with CFR 0.152.
 */
package uushadoworg.joda.time.convert;

import java.util.Calendar;
import java.util.GregorianCalendar;
import uushadoworg.joda.time.Chronology;
import uushadoworg.joda.time.DateTimeZone;
import uushadoworg.joda.time.chrono.BuddhistChronology;
import uushadoworg.joda.time.chrono.GJChronology;
import uushadoworg.joda.time.chrono.GregorianChronology;
import uushadoworg.joda.time.chrono.ISOChronology;
import uushadoworg.joda.time.chrono.JulianChronology;
import uushadoworg.joda.time.convert.AbstractConverter;
import uushadoworg.joda.time.convert.InstantConverter;
import uushadoworg.joda.time.convert.PartialConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();

    protected CalendarConverter() {
    }

    @Override
    public Chronology getChronology(Object object, Chronology chronology) {
        if (chronology != null) {
            return chronology;
        }
        Calendar calendar = (Calendar)object;
        DateTimeZone dateTimeZone = null;
        try {
            dateTimeZone = DateTimeZone.forTimeZone(calendar.getTimeZone());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)calendar, dateTimeZone);
    }

    @Override
    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(dateTimeZone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            long l = gregorianCalendar.getGregorianChange().getTime();
            if (l == Long.MIN_VALUE) {
                return GregorianChronology.getInstance(dateTimeZone);
            }
            if (l == Long.MAX_VALUE) {
                return JulianChronology.getInstance(dateTimeZone);
            }
            return GJChronology.getInstance(dateTimeZone, l, 4);
        }
        return ISOChronology.getInstance(dateTimeZone);
    }

    @Override
    public long getInstantMillis(Object object, Chronology chronology) {
        Calendar calendar = (Calendar)object;
        return calendar.getTime().getTime();
    }

    @Override
    public Class<?> getSupportedType() {
        return Calendar.class;
    }
}

