/*
 * Decompiled with CFR 0.152.
 */
package uushadoworg.joda.time.convert;

import uushadoworg.joda.time.Chronology;
import uushadoworg.joda.time.DateTimeUtils;
import uushadoworg.joda.time.ReadWritableInterval;
import uushadoworg.joda.time.ReadWritablePeriod;
import uushadoworg.joda.time.ReadableInterval;
import uushadoworg.joda.time.convert.AbstractConverter;
import uushadoworg.joda.time.convert.DurationConverter;
import uushadoworg.joda.time.convert.IntervalConverter;
import uushadoworg.joda.time.convert.PeriodConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadableIntervalConverter
extends AbstractConverter
implements IntervalConverter,
DurationConverter,
PeriodConverter {
    static final ReadableIntervalConverter INSTANCE = new ReadableIntervalConverter();

    protected ReadableIntervalConverter() {
    }

    @Override
    public long getDurationMillis(Object object) {
        return ((ReadableInterval)object).toDurationMillis();
    }

    @Override
    public void setInto(ReadWritablePeriod readWritablePeriod, Object object, Chronology chronology) {
        ReadableInterval readableInterval = (ReadableInterval)object;
        chronology = chronology != null ? chronology : DateTimeUtils.getIntervalChronology(readableInterval);
        long l = readableInterval.getStartMillis();
        long l2 = readableInterval.getEndMillis();
        int[] nArray = chronology.get(readWritablePeriod, l, l2);
        for (int i = 0; i < nArray.length; ++i) {
            readWritablePeriod.setValue(i, nArray[i]);
        }
    }

    @Override
    public boolean isReadableInterval(Object object, Chronology chronology) {
        return true;
    }

    @Override
    public void setInto(ReadWritableInterval readWritableInterval, Object object, Chronology chronology) {
        ReadableInterval readableInterval = (ReadableInterval)object;
        readWritableInterval.setInterval(readableInterval);
        if (chronology != null) {
            readWritableInterval.setChronology(chronology);
        } else {
            readWritableInterval.setChronology(readableInterval.getChronology());
        }
    }

    @Override
    public Class<?> getSupportedType() {
        return ReadableInterval.class;
    }
}

