/*
 * Decompiled with CFR 0.152.
 */
package uniquee.client;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.simple.EnchantmentTreasurersEyes;
import uniquee.utils.MiscUtil;

public class EnchantmentLayer
implements LayerRenderer<EntityLivingBase> {
    public boolean canSeeEffects(EntityLivingBase base) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.TREASURERS_EYES, player.func_184582_a(EntityEquipmentSlot.HEAD));
        if (level > 0) {
            double maxDistance = EnchantmentTreasurersEyes.RANGE.getAsDouble(level);
            maxDistance *= maxDistance;
            return player.func_70068_e((Entity)base) <= maxDistance;
        }
        return false;
    }

    public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (entity.getEntityData().func_74763_f("effectTimer") == entity.field_70170_p.func_82737_E()) {
            return;
        }
        long time = entity.field_70170_p.func_82737_E();
        entity.getEntityData().func_74772_a("effectTimer", time);
        if (!this.canSeeEffects(entity)) {
            return;
        }
        if (time % 14L == 0L && MiscUtil.getEnchantmentLevel(UniqueEnchantments.ARES_BLESSING, entity.func_184582_a(EntityEquipmentSlot.CHEST)) > 0) {
            this.spawnParticle(EnumParticleTypes.HEART, entity.field_70170_p, entity.func_174813_aQ(), 0.0f, 0.0f, 0.0f, 0.0f, 0.8f, 0.0f);
        }
        if (time % 2L == 0L) {
            Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(entity.func_184614_ca());
            if (enchantments.getInt((Object)UniqueEnchantments.BERSERKER) > 0) {
                this.spawnParticle(EnumParticleTypes.REDSTONE, entity.field_70170_p, entity.func_174813_aQ(), 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            if (enchantments.getInt((Object)UniqueEnchantments.PERPETUAL_STRIKE) > 0) {
                this.spawnParticle(EnumParticleTypes.REDSTONE, entity.field_70170_p, entity.func_174813_aQ(), 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            }
            if (enchantments.getInt((Object)UniqueEnchantments.SPARTAN_WEAPON) > 0) {
                this.spawnParticle(EnumParticleTypes.REDSTONE, entity.field_70170_p, entity.func_174813_aQ(), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            if (enchantments.getInt((Object)UniqueEnchantments.ALCHEMISTS_GRACE) > 0) {
                int value = (int)(time % 90L);
                this.spawnParticle(EnumParticleTypes.REDSTONE, entity.field_70170_p, entity.func_174813_aQ(), value >= 0 && value < 30 ? 1.0f : 0.0f, value >= 30 && value < 60 ? 1.0f : 0.0f, value >= 60 && value < 90 ? 1.0f : 0.0f, 0.0f, 0.0f, 0.0f);
            }
            if (enchantments.getInt((Object)UniqueEnchantments.PHOENIX_BLESSING) > 0) {
                AxisAlignedBB box = entity.func_174813_aQ();
                float width = (float)(box.field_72336_d - box.field_72340_a);
                float debth = (float)(box.field_72334_f - box.field_72339_c);
                float xOffset = width * entity.field_70170_p.field_73012_v.nextFloat() - width / 2.0f;
                float zOffset = debth * entity.field_70170_p.field_73012_v.nextFloat() - debth / 2.0f;
                entity.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, entity.field_70165_t + (double)xOffset, entity.field_70163_u, entity.field_70161_v + (double)zOffset, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected void spawnParticles(EnumParticleTypes type, World world, AxisAlignedBB box, float r, float g, float b, float xOff, float yOff, float zOff, int count) {
        for (int i = 0; i < count; ++i) {
            this.spawnParticle(type, world, box, r, g, b, xOff, yOff, zOff);
        }
    }

    protected void spawnParticle(EnumParticleTypes type, World world, AxisAlignedBB box, float r, float g, float b, float xOff, float yOff, float zOff) {
        float width = (float)(box.field_72336_d - box.field_72340_a);
        float height = (float)(box.field_72337_e - box.field_72338_b);
        float debth = (float)(box.field_72334_f - box.field_72339_c);
        float xOffset = width * world.field_73012_v.nextFloat();
        float yOffset = height * world.field_73012_v.nextFloat();
        float zOffset = debth * world.field_73012_v.nextFloat();
        Particle particle = Minecraft.func_71410_x().field_71452_i.func_178927_a(type.func_179348_c(), (double)((float)box.field_72340_a + xOffset + xOff), (double)((float)box.field_72338_b + yOffset + yOff), (double)((float)box.field_72339_c + zOffset + zOff), 0.0, 0.0, 0.0, new int[0]);
        if (particle != null) {
            particle.func_70538_b(r, g, b);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

