/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import uniquee.enchantments.IToggleEnchantment;

public abstract class UniqueEnchantment
extends Enchantment
implements IToggleEnchantment {
    public static final Enchantment.Rarity[] RARITIES = Enchantment.Rarity.values();
    DefaultData defaults;
    DefaultData actualData;
    protected boolean enabled = false;
    String configName;
    String categoryName = "base";

    protected UniqueEnchantment(DefaultData data, EnumEnchantmentType typeIn, EntityEquipmentSlot[] slots) {
        super(data.getRarity(), typeIn, slots);
        this.func_77322_b(Loader.instance().activeModContainer().getModId() + "." + data.getName());
        this.setRegistryName(data.getName());
        this.configName = data.getName();
        this.defaults = data;
        this.actualData = data;
    }

    public int func_77319_d() {
        return this.actualData.getMinLevel();
    }

    public int func_77325_b() {
        return this.actualData.getMaxLevel();
    }

    public boolean func_185261_e() {
        return this.actualData.isTreasure();
    }

    public int func_77321_a(int enchantmentLevel) {
        return this.actualData.getLevelCost(enchantmentLevel);
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + this.actualData.getRangeCost();
    }

    public Enchantment.Rarity func_77324_c() {
        return this.actualData.getRarity();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.enabled ? (super.canApplyAtEnchantingTable(stack) || this.canApplyToItem(stack)) && !this.canNotApplyToItems(stack) : false;
    }

    public boolean isAllowedOnBooks() {
        return this.enabled;
    }

    protected boolean canApplyToItem(ItemStack stack) {
        return false;
    }

    protected boolean canNotApplyToItems(ItemStack stack) {
        return false;
    }

    @Override
    public String getConfigName() {
        return this.categoryName + "." + this.configName;
    }

    protected void setCategory(String name) {
        this.categoryName = name;
    }

    @Override
    public final void loadFromConfig(Configuration config) {
        this.enabled = config.get(this.getConfigName(), "enabled", true).getBoolean();
        this.actualData = new DefaultData(this.defaults, config, this.getConfigName());
        this.loadData(config);
        config.getCategory(this.getConfigName()).setLanguageKey(this.func_77320_a());
    }

    public abstract void loadData(Configuration var1);

    public static class DefaultData {
        String name;
        Enchantment.Rarity rare;
        int minLevel;
        int maxLevel;
        boolean isTreasure;
        int baseCost;
        int levelCost;
        int rangeCost;

        public DefaultData(DefaultData defaultValues, Configuration config, String configName) {
            this.name = defaultValues.getName();
            this.minLevel = config.get(configName, "min_level", defaultValues.getMinLevel()).getInt();
            this.maxLevel = config.get(configName, "max_level", defaultValues.getMaxLevel()).getInt();
            this.rare = RARITIES[config.get(configName, "rarity", defaultValues.getRarity().ordinal()).getInt()];
            this.isTreasure = config.get(configName, "treasure", defaultValues.isTreasure()).getBoolean();
            this.baseCost = config.get(configName, "base_cost", defaultValues.getBaseCost()).getInt();
            this.levelCost = config.get(configName, "per_level_cost", defaultValues.getLevelCost()).getInt();
            this.rangeCost = config.get(configName, "cost_limit", defaultValues.getRangeCost()).getInt();
        }

        public DefaultData(String name, Enchantment.Rarity rare, int maxLevel, boolean isTreasure, int baseCost, int levelCost, int rangeCost) {
            this(name, rare, 1, maxLevel, isTreasure, baseCost, levelCost, rangeCost);
        }

        public DefaultData(String name, Enchantment.Rarity rare, int minLevel, int maxLevel, boolean isTreasure, int baseCost, int levelCost, int rangeCost) {
            this.name = name;
            this.rare = rare;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.isTreasure = isTreasure;
            this.baseCost = baseCost;
            this.levelCost = levelCost;
            this.rangeCost = rangeCost;
        }

        public int getLevelCost(int minLevel) {
            return this.baseCost - this.levelCost + minLevel * this.levelCost;
        }

        public String getName() {
            return this.name;
        }

        public Enchantment.Rarity getRarity() {
            return this.rare;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public boolean isTreasure() {
            return this.isTreasure;
        }

        public int getBaseCost() {
            return this.baseCost;
        }

        public int getLevelCost() {
            return this.levelCost;
        }

        public int getRangeCost() {
            return this.rangeCost;
        }
    }
}

