/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.UniqueEnchantment;
import uniquee.enchantments.type.IGraceEnchantment;
import uniquee.enchantments.unique.EnchantmentNaturesGrace;
import uniquee.enchantments.unique.EnchantmentWarriorsGrace;
import uniquee.utils.MiscUtil;

public class EnchantmentAlchemistsGrace
extends UniqueEnchantment
implements IGraceEnchantment {
    public static final List<List<PotionPlan>> EFFECTS = new ObjectArrayList();

    public EnchantmentAlchemistsGrace() {
        super(new UniqueEnchantment.DefaultData("alchemistsgrace", Enchantment.Rarity.VERY_RARE, 4, true, 20, 3, 18), EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
    }

    @Override
    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemTool || EnumEnchantmentType.BOW.func_77557_a(stack.func_77973_b());
    }

    protected boolean func_77326_a(Enchantment ench) {
        return ench instanceof EnchantmentWarriorsGrace || ench instanceof EnchantmentNaturesGrace ? false : super.func_77326_a(ench);
    }

    public static void applyToEntity(Entity entity) {
        EntityLivingBase base;
        Object2IntMap.Entry<EntityEquipmentSlot> slot;
        if (entity instanceof EntityLivingBase && (slot = MiscUtil.getEnchantedItem(UniqueEnchantments.ALCHEMISTS_GRACE, base = (EntityLivingBase)entity)).getIntValue() > 0) {
            int level = slot.getIntValue();
            ObjectOpenHashSet potions = new ObjectOpenHashSet();
            for (int i = level; i >= 0; --i) {
                if (EFFECTS.size() <= i) continue;
                for (PotionPlan plan : EFFECTS.get(i)) {
                    PotionEffect effect = plan.createEffect(level);
                    if (!potions.add(effect.func_188419_a())) continue;
                    base.func_70690_d(effect);
                }
            }
        }
    }

    @Override
    public void loadData(Configuration config) {
        String[] potions;
        EFFECTS.clear();
        for (String s : potions = config.getStringList("effects", this.getConfigName(), new String[]{"minecraft:regeneration;1;0;0.25;10", "minecraft:speed;1;0;1.0;60", "minecraft:haste;2;0;1.0;40", "minecraft:speed;2;1;0.5;70", "minecraft:resistance;3;0;1.0;20", "minecraft:haste;3;1;0.5;60", "minecraft:strength;4;0;1.0;20", "minecraft:resistance;4;1;0.25;25", "minecraft:strength;5;1;0.2;30"}, "Which Potion Effects should be applied. Format: Potion;MinimumEnchantLevel;PotionBaseLevel;PotionLevelIncrease;BaseDuration")) {
            Potion p;
            String[] split = s.split(";");
            if (split.length != 5 || (p = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(split[0]))) == null) continue;
            try {
                PotionPlan plan = new PotionPlan(p, split);
                while (EFFECTS.size() <= plan.baseEnchantment) {
                    EFFECTS.add((List<PotionPlan>)new ObjectArrayList());
                }
                EFFECTS.get(plan.baseEnchantment).add(plan);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class PotionPlan {
        Potion potion;
        int baseEnchantment;
        int basePotionLevel;
        double PotionLevelIncrease;
        int baseDuration;

        public PotionPlan(Potion potion, String[] data) {
            this.potion = potion;
            this.baseEnchantment = Integer.parseInt(data[1]);
            this.basePotionLevel = Integer.parseInt(data[2]);
            this.PotionLevelIncrease = Double.parseDouble(data[3]);
            this.baseDuration = Integer.parseInt(data[4]);
        }

        public PotionEffect createEffect(int baseLevel) {
            int diff = Math.max(0, baseLevel - this.baseEnchantment);
            return new PotionEffect(this.potion, this.baseDuration * baseLevel, this.basePotionLevel + (int)(this.PotionLevelIncrease * (double)diff));
        }
    }
}

