/*
 * Decompiled with CFR 0.152.
 */
package uniquee.utils;

import net.minecraftforge.common.config.Configuration;

public class DoubleLevelStats {
    String name;
    final double baseConfig;
    final double levelConfig;
    double base;
    double level;

    public DoubleLevelStats(String name, double base, double level) {
        this.name = name;
        this.baseConfig = base;
        this.levelConfig = level;
        this.base = base;
        this.level = level;
    }

    public void handleConfig(Configuration config, String category) {
        this.base = config.get(category, this.name + "_base", this.baseConfig).getDouble();
        this.level = config.get(category, this.name + "_level", this.levelConfig).getDouble();
    }

    public void handleConfig(Configuration config, String category, String comment) {
        this.base = config.get(category, this.name + "_base", this.baseConfig, comment).getDouble();
        this.level = config.get(category, this.name + "_level", this.levelConfig).getDouble();
    }

    public double getAsDouble(int level) {
        return this.base + this.level * (double)level;
    }

    public float getAsFloat(int level) {
        return (float)(this.base + this.level * (double)level);
    }

    public float getDevided(int level) {
        return (float)(this.base / (this.level * (double)level));
    }
}

