/*
 * Decompiled with CFR 0.152.
 */
package uniquee.utils;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import uniquee.api.crops.CropHarvestRegistry;

public class HarvestEntry {
    int dim;
    long position;

    public HarvestEntry(NBTTagCompound nbt) {
        this(nbt.func_74762_e("dim"), nbt.func_74763_f("pos"));
    }

    public HarvestEntry(int dim, long position) {
        this.dim = dim;
        this.position = position;
    }

    public boolean matches(NBTTagCompound nbt) {
        return this.dim == nbt.func_74762_e("dim") && this.position == nbt.func_74763_f("pos");
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dim", this.dim);
        compound.func_74772_a("pos", this.position);
        return compound;
    }

    public EnumActionResult harvest(World world, EntityPlayer player) {
        if (world.field_73011_w.getDimension() != this.dim) {
            return EnumActionResult.PASS;
        }
        BlockPos pos = BlockPos.func_177969_a((long)this.position);
        return world.func_175667_e(pos) ? CropHarvestRegistry.INSTANCE.tryHarvest(world.func_180495_p(pos), world, pos, player) : EnumActionResult.PASS;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.dim);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HarvestEntry) {
            HarvestEntry entry = (HarvestEntry)obj;
            return entry.dim == this.dim && entry.position == this.position;
        }
        return false;
    }
}

