/*
 * Decompiled with CFR 0.152.
 */
package uniquee.client;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.simple.TreasurersEyesEnchantment;
import uniquee.utils.MiscUtil;

public class EnchantmentLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public EnchantmentLayer(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public boolean canSeeEffects(LivingEntity base) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.TREASURERS_EYES, player.func_184582_a(EquipmentSlotType.HEAD));
        if (level > 0) {
            double maxDistance = TreasurersEyesEnchantment.RANGE.getAsDouble(level);
            maxDistance *= maxDistance;
            return player.func_70068_e((Entity)base) <= maxDistance;
        }
        return true;
    }

    public void render(LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (entity.getPersistentData().func_74763_f("effectTimer") == entity.field_70170_p.func_82737_E()) {
            return;
        }
        long time = entity.field_70170_p.func_82737_E();
        entity.getPersistentData().func_74772_a("effectTimer", time);
        if (!this.canSeeEffects(entity)) {
            return;
        }
        if (time % 14L == 0L && MiscUtil.getEnchantmentLevel(UniqueEnchantments.ARES_BLESSING, entity.func_184582_a(EquipmentSlotType.CHEST)) > 0) {
            this.spawnParticle((IParticleData)ParticleTypes.field_197633_z, entity.field_70170_p, entity.func_174813_aQ(), 0.0f, 0.8f, 0.0f);
        }
        if (time % 2L == 0L) {
            Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(entity.func_184614_ca());
            if (enchantments.getInt((Object)UniqueEnchantments.BERSERKER) > 0) {
                this.spawnParticle((IParticleData)new RedstoneParticleData(1.0f, 0.0f, 0.0f, 1.0f), entity.field_70170_p, entity.func_174813_aQ(), 0.0f, 0.0f, 0.0f);
            }
            if (enchantments.getInt((Object)UniqueEnchantments.PERPETUAL_STRIKE) > 0) {
                this.spawnParticle((IParticleData)new RedstoneParticleData(0.0f, 0.0f, 1.0f, 1.0f), entity.field_70170_p, entity.func_174813_aQ(), 0.0f, 0.0f, 0.0f);
            }
            if (enchantments.getInt((Object)UniqueEnchantments.SPARTAN_WEAPON) > 0) {
                this.spawnParticle((IParticleData)new RedstoneParticleData(0.0f, 1.0f, 0.0f, 1.0f), entity.field_70170_p, entity.func_174813_aQ(), 0.0f, 0.0f, 0.0f);
            }
            if (enchantments.getInt((Object)UniqueEnchantments.ALCHEMISTS_GRACE) > 0) {
                int value = (int)(time % 90L);
                this.spawnParticle((IParticleData)new RedstoneParticleData(value >= 0 && value < 30 ? 1.0f : 0.0f, value >= 30 && value < 60 ? 1.0f : 0.0f, value >= 60 && value < 90 ? 1.0f : 0.0f, 1.0f), entity.field_70170_p, entity.func_174813_aQ(), 0.0f, 0.0f, 0.0f);
            }
            if (enchantments.getInt((Object)UniqueEnchantments.PHOENIX_BLESSING) > 0) {
                AxisAlignedBB box = entity.func_174813_aQ();
                float width = (float)(box.field_72336_d - box.field_72340_a);
                float debth = (float)(box.field_72334_f - box.field_72339_c);
                float xOffset = width * entity.field_70170_p.field_73012_v.nextFloat() - width / 2.0f;
                float zOffset = debth * entity.field_70170_p.field_73012_v.nextFloat() - debth / 2.0f;
                entity.field_70170_p.func_195589_b((IParticleData)ParticleTypes.field_197631_x, entity.field_70165_t + (double)xOffset, entity.field_70163_u, entity.field_70161_v + (double)zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void spawnParticle(IParticleData type, World world, AxisAlignedBB box, float xOff, float yOff, float zOff) {
        float width = (float)(box.field_72336_d - box.field_72340_a);
        float height = (float)(box.field_72337_e - box.field_72338_b);
        float debth = (float)(box.field_72334_f - box.field_72339_c);
        float xOffset = width * world.field_73012_v.nextFloat();
        float yOffset = height * world.field_73012_v.nextFloat();
        float zOffset = debth * world.field_73012_v.nextFloat();
        ((ClientWorld)world).func_195589_b(type, (double)((float)box.field_72340_a + xOffset + xOff), (double)((float)box.field_72338_b + yOffset + yOff), (double)((float)box.field_72339_c + zOffset + zOff), 0.0, 0.0, 0.0);
    }

    public boolean func_177142_b() {
        return false;
    }
}

