/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import uniquee.enchantments.IToggleEnchantment;

public abstract class UniqueEnchantment
extends Enchantment
implements IToggleEnchantment {
    public static final Enchantment.Rarity[] RARITIES = Enchantment.Rarity.values();
    DefaultData values;
    protected ForgeConfigSpec.BooleanValue enabled;
    String configName;
    String categoryName = "base";

    protected UniqueEnchantment(DefaultData data, EnchantmentType typeIn, EquipmentSlotType[] slots) {
        super(data.getRarity(), typeIn, slots);
        this.setRegistryName(data.getName());
        this.configName = data.getName();
        this.values = data;
    }

    public int func_77325_b() {
        return this.values.getMaxLevel();
    }

    public int func_77319_d() {
        return this.values.getMinLevel();
    }

    public boolean func_185261_e() {
        return this.values.isTreasure();
    }

    public int func_77321_a(int enchantmentLevel) {
        return this.values.getLevelCost(enchantmentLevel);
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + this.values.getRangeCost();
    }

    public Enchantment.Rarity func_77324_c() {
        return this.values.getRarity();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ((Boolean)this.enabled.get()).booleanValue() ? (super.canApplyAtEnchantingTable(stack) || this.canApplyToItem(stack)) && !this.canNotApplyToItems(stack) : false;
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)this.enabled.get();
    }

    protected boolean canApplyToItem(ItemStack stack) {
        return false;
    }

    protected boolean canNotApplyToItems(ItemStack stack) {
        return false;
    }

    @Override
    public String getConfigName() {
        return this.categoryName + "." + this.configName;
    }

    protected void setCategory(String name) {
        this.categoryName = name;
    }

    @Override
    public final void loadFromConfig(ForgeConfigSpec.Builder config) {
        int split = this.getConfigName().split(".").length + 2;
        config.push(this.getConfigName());
        this.enabled = config.define("enabled", true);
        this.values.loadConfig(config);
        this.loadData(config);
        config.pop(split);
    }

    public abstract void loadData(ForgeConfigSpec.Builder var1);

    public static class DefaultData {
        int minLevel;
        int maxLevel;
        String name;
        Enchantment.Rarity rare;
        boolean isTreasure;
        int baseCost;
        int levelCost;
        int rangeCost;
        ForgeConfigSpec.EnumValue<Enchantment.Rarity> rare_Config;
        ForgeConfigSpec.BooleanValue isTreasure_Config;
        ForgeConfigSpec.IntValue baseCost_Config;
        ForgeConfigSpec.IntValue levelCost_Config;
        ForgeConfigSpec.IntValue rangeCost_Config;
        ForgeConfigSpec.IntValue minLevel_Config;
        ForgeConfigSpec.IntValue maxLevel_Config;

        public DefaultData(String name, Enchantment.Rarity rare, int maxLevel, boolean isTreasure, int baseCost, int levelCost, int rangeCost) {
            this(name, rare, 1, maxLevel, isTreasure, baseCost, levelCost, rangeCost);
        }

        public DefaultData(String name, Enchantment.Rarity rare, int minLevel, int maxLevel, boolean isTreasure, int baseCost, int levelCost, int rangeCost) {
            this.name = name;
            this.rare = rare;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.isTreasure = isTreasure;
            this.baseCost = baseCost;
            this.levelCost = levelCost;
            this.rangeCost = rangeCost;
        }

        public void loadConfig(ForgeConfigSpec.Builder config) {
            this.minLevel_Config = config.defineInRange("min_level", this.minLevel, 0, Integer.MAX_VALUE);
            this.maxLevel_Config = config.defineInRange("max_level", this.maxLevel, 0, Integer.MAX_VALUE);
            this.rare_Config = config.defineEnum("rarity", (Enum)this.rare);
            this.isTreasure_Config = config.define("treasure", this.isTreasure);
            this.baseCost_Config = config.defineInRange("base_cost", this.baseCost, 0, Integer.MAX_VALUE);
            this.levelCost_Config = config.defineInRange("per_level_cost", this.levelCost, 0, Integer.MAX_VALUE);
            this.rangeCost_Config = config.defineInRange("cost_limit", this.rangeCost, 0, Integer.MAX_VALUE);
        }

        public int getLevelCost(int minLevel) {
            int level = this.getLevelCost();
            return this.getBaseCost() - level + minLevel * level;
        }

        public String getName() {
            return this.name;
        }

        public int getMinLevel() {
            return this.minLevel_Config != null ? (Integer)this.minLevel_Config.get() : this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel_Config != null ? (Integer)this.maxLevel_Config.get() : this.maxLevel;
        }

        public Enchantment.Rarity getRarity() {
            return this.rare_Config != null ? (Enchantment.Rarity)this.rare_Config.get() : this.rare;
        }

        public boolean isTreasure() {
            return this.isTreasure_Config != null ? (Boolean)this.isTreasure_Config.get() : this.isTreasure;
        }

        public int getBaseCost() {
            return this.baseCost_Config != null ? (Integer)this.baseCost_Config.get() : this.baseCost;
        }

        public int getLevelCost() {
            return this.levelCost_Config != null ? (Integer)this.levelCost_Config.get() : this.levelCost;
        }

        public int getRangeCost() {
            return this.rangeCost_Config != null ? (Integer)this.rangeCost_Config.get() : this.rangeCost;
        }
    }
}

