/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.UniqueEnchantment;
import uniquee.enchantments.type.IGraceEnchantment;
import uniquee.enchantments.unique.NaturesGraceEnchantment;
import uniquee.enchantments.unique.WarriorsGraceEnchantment;
import uniquee.utils.MiscUtil;

public class AlchemistsGraceEnchantment
extends UniqueEnchantment
implements IGraceEnchantment {
    public static final List<List<PotionPlan>> EFFECTS = new ObjectArrayList();
    static ForgeConfigSpec.ConfigValue<List<? extends String>> EFFECT_CONFIG;

    public AlchemistsGraceEnchantment() {
        super(new UniqueEnchantment.DefaultData("alchemistsgrace", Enchantment.Rarity.VERY_RARE, 4, true, 20, 3, 18), EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND, EquipmentSlotType.OFFHAND});
    }

    @Override
    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ToolItem || EnchantmentType.BOW.func_77557_a(stack.func_77973_b());
    }

    protected boolean func_77326_a(Enchantment ench) {
        return ench instanceof WarriorsGraceEnchantment || ench instanceof NaturesGraceEnchantment ? false : super.func_77326_a(ench);
    }

    public static void applyToEntity(Entity entity) {
        LivingEntity base;
        Object2IntMap.Entry<EquipmentSlotType> slot;
        if (entity instanceof LivingEntity && (slot = MiscUtil.getEnchantedItem(UniqueEnchantments.ALCHEMISTS_GRACE, base = (LivingEntity)entity)).getIntValue() > 0) {
            int level = slot.getIntValue();
            ObjectOpenHashSet potions = new ObjectOpenHashSet();
            for (int i = level; i >= 0; --i) {
                if (EFFECTS.size() <= i) continue;
                for (PotionPlan plan : EFFECTS.get(i)) {
                    EffectInstance effect = plan.createEffect(level);
                    if (!potions.add(effect.func_188419_a())) continue;
                    base.func_195064_c(effect);
                }
            }
        }
    }

    @Override
    public void loadData(ForgeConfigSpec.Builder config) {
        config.comment("Which Potion Effects should be applied. Format: Potion;StartEnchantmentLvL;StartPotionLvL;PotionLvLPerEnchantLvL;BaseDuration");
        EFFECT_CONFIG = config.defineList("effects", (List)ObjectArrayList.wrap((Object[])new String[]{"minecraft:regeneration;1;0;0.25;10", "minecraft:speed;1;0;1.0;60", "minecraft:haste;2;0;1.0;40", "minecraft:speed;2;1;0.5;70", "minecraft:resistance;3;0;1.0;20", "minecraft:haste;3;1;0.5;60", "minecraft:strength;4;0;1.0;20", "minecraft:resistance;4;1;0.25;25", "minecraft:strength;5;1;0.2;30"}), T -> true);
    }

    @Override
    public void onConfigChanged() {
        EFFECTS.clear();
        List list = (List)EFFECT_CONFIG.get();
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            Effect p;
            String[] split = ((String)list.get(i)).split(";");
            if (split.length != 5 || (p = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(split[0]))) == null) continue;
            try {
                PotionPlan plan = new PotionPlan(p, split);
                while (EFFECTS.size() <= plan.baseEnchantment) {
                    EFFECTS.add((List<PotionPlan>)new ObjectArrayList());
                }
                EFFECTS.get(plan.baseEnchantment).add(plan);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class PotionPlan {
        Effect potion;
        int baseEnchantment;
        int basePotionLevel;
        double PotionLevelIncrease;
        int baseDuration;

        public PotionPlan(Effect potion, String[] data) {
            this.potion = potion;
            this.baseEnchantment = Integer.parseInt(data[1]);
            this.basePotionLevel = Integer.parseInt(data[2]);
            this.PotionLevelIncrease = Double.parseDouble(data[3]);
            this.baseDuration = Integer.parseInt(data[4]);
        }

        public EffectInstance createEffect(int baseLevel) {
            int diff = Math.max(0, baseLevel - this.baseEnchantment);
            return new EffectInstance(this.potion, this.baseDuration * baseLevel, this.basePotionLevel + (int)(this.PotionLevelIncrease * (double)diff));
        }
    }
}

