/*
 * Decompiled with CFR 0.152.
 */
package uniquee.utils;

import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import uniquee.api.crops.CropHarvestRegistry;

public class HarvestEntry {
    int dim;
    long position;

    public HarvestEntry(CompoundNBT nbt) {
        this(nbt.func_74762_e("dim"), nbt.func_74763_f("pos"));
    }

    public HarvestEntry(int dim, long position) {
        this.dim = dim;
        this.position = position;
    }

    public boolean matches(CompoundNBT nbt) {
        return this.dim == nbt.func_74762_e("dim") && this.position == nbt.func_74763_f("pos");
    }

    public CompoundNBT save() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("dim", this.dim);
        compound.func_74772_a("pos", this.position);
        return compound;
    }

    public ActionResultType harvest(World world, PlayerEntity player) {
        if (world.func_201675_m().func_186058_p().func_186068_a() != this.dim) {
            return ActionResultType.PASS;
        }
        BlockPos pos = BlockPos.func_218283_e((long)this.position);
        return world.func_195588_v(pos) ? CropHarvestRegistry.INSTANCE.tryHarvest(world.func_180495_p(pos), world, pos, player) : ActionResultType.PASS;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.dim);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HarvestEntry) {
            HarvestEntry entry = (HarvestEntry)obj;
            return entry.dim == this.dim && entry.position == this.position;
        }
        return false;
    }
}

