/*
 * Decompiled with CFR 0.152.
 */
package uniquee.utils;

import net.minecraftforge.common.ForgeConfigSpec;

public class IntLevelStats {
    String name;
    final int baseConfig;
    final int levelConfig;
    ForgeConfigSpec.IntValue base;
    ForgeConfigSpec.IntValue level;

    public IntLevelStats(String name, int base, int level) {
        this.name = name;
        this.baseConfig = base;
        this.levelConfig = level;
    }

    public void handleConfig(ForgeConfigSpec.Builder config) {
        this.base = config.defineInRange(this.name + "_base", this.baseConfig, 0, Integer.MAX_VALUE);
        this.level = config.defineInRange(this.name + "_level", this.levelConfig, 0, Integer.MAX_VALUE);
    }

    public void handleConfig(ForgeConfigSpec.Builder config, String comment) {
        config.comment(comment);
        this.base = config.defineInRange(this.name + "_base", this.baseConfig, 0, Integer.MAX_VALUE);
        this.level = config.defineInRange(this.name + "_level", this.levelConfig, 0, Integer.MAX_VALUE);
    }

    public int getBase() {
        return this.base != null ? (Integer)this.base.get() : this.baseConfig;
    }

    public int getLevel() {
        return this.level != null ? (Integer)this.level.get() : this.levelConfig;
    }

    public int get(int level) {
        return this.getBase() + this.getLevel() * level;
    }
}

