/*
 * Decompiled with CFR 0.152.
 */
package uniquee.utils;

import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MiscUtil {
    static final Consumer<LivingEntity>[] SLOT_BASE = MiscUtil.createSlots();

    static Consumer<LivingEntity>[] createSlots() {
        Consumer[] slots = new Consumer[EquipmentSlotType.values().length];
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            slots[slot.func_188454_b()] = entity -> entity.func_213361_c(slot);
        }
        return slots;
    }

    public static Consumer<LivingEntity> get(EquipmentSlotType slot) {
        return slot == null ? SLOT_BASE[0] : SLOT_BASE[slot.func_188454_b()];
    }

    public static int getEnchantmentLevel(Enchantment ench, ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        ListNBT list = stack.func_77986_q();
        if (list.isEmpty()) {
            return 0;
        }
        String id = ench.getRegistryName().toString();
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            if (!tag.func_74779_i("id").equalsIgnoreCase(id)) continue;
            return tag.func_74762_e("lvl");
        }
        return 0;
    }

    public static int getCombinedEnchantmentLevel(Enchantment ench, LivingEntity base) {
        EquipmentSlotType[] slots = MiscUtil.getEquipmentSlotsFor(ench);
        if (slots.length <= 0) {
            return 0;
        }
        int totalLevel = 0;
        for (int i = 0; i < slots.length; ++i) {
            totalLevel += MiscUtil.getEnchantmentLevel(ench, base.func_184582_a(slots[i]));
        }
        return totalLevel;
    }

    public static Object2IntMap<Enchantment> getEnchantments(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Object2IntMaps.emptyMap();
        }
        ListNBT list = stack.func_77986_q();
        if (list.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(tag.func_74779_i("id")));
            if (enchantment == null) continue;
            map.put((Object)enchantment, tag.func_74762_e("lvl"));
        }
        return map;
    }

    public static EquipmentSlotType[] getEquipmentSlotsFor(Enchantment ench) {
        try {
            return MiscUtil.findField(Enchantment.class, ench, EquipmentSlotType[].class, "applicableEquipmentTypes", "field_185263_a");
        }
        catch (Exception exception) {
            return new EquipmentSlotType[0];
        }
    }

    public static Set<EquipmentSlotType> getSlotsFor(Enchantment ench) {
        Object[] slots = MiscUtil.getEquipmentSlotsFor(ench);
        return slots.length <= 0 ? Collections.emptySet() : new ObjectOpenHashSet(slots);
    }

    public static Object2IntMap.Entry<EquipmentSlotType> getEnchantedItem(Enchantment enchantment, LivingEntity base) {
        EquipmentSlotType[] slots = MiscUtil.getEquipmentSlotsFor(enchantment);
        if (slots.length <= 0) {
            return new AbstractObject2IntMap.BasicEntry(null, 0);
        }
        for (int i = 0; i < slots.length; ++i) {
            int level = MiscUtil.getEnchantmentLevel(enchantment, base.func_184582_a(slots[i]));
            if (level <= 0) continue;
            return new AbstractObject2IntMap.BasicEntry((Object)slots[i], level);
        }
        return new AbstractObject2IntMap.BasicEntry(null, 0);
    }

    public static Method findMethod(Class<?> clz, String[] names, Class<?> ... variables) {
        for (String s : names) {
            try {
                Method method = clz.getDeclaredMethod(s, variables);
                method.setAccessible(true);
                return method;
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException("Couldnt find methods: " + ObjectArrayList.wrap((Object[])names));
    }

    public static <T> T findField(Class<?> clz, Object instance, Class<T> result, String ... names) {
        for (String s : names) {
            try {
                Field field = clz.getDeclaredField(s);
                field.setAccessible(true);
                return (T)field.get(instance);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException("Couldnt find fields: " + ObjectArrayList.wrap((Object[])names));
    }

    public static boolean harvestBlock(BlockEvent.BreakEvent event, BlockState state, BlockPos pos) {
        boolean flag;
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return false;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        World world = (World)event.getWorld();
        TileEntity tileentity = world.func_175625_s(pos);
        Block block = state.func_177230_c();
        if ((block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.func_195070_dx()) {
            world.func_184138_a(pos, state, state, 3);
            return false;
        }
        if (player.func_184614_ca().onBlockStartBreak(pos, (PlayerEntity)player)) {
            return false;
        }
        if (player.func_223729_a(world, pos, player.field_71134_c.func_73081_b())) {
            return false;
        }
        if (player.func_184812_l_()) {
            MiscUtil.removeBlock(world, pos, player, false);
            return true;
        }
        int exp = event.getExpToDrop();
        ItemStack itemstack = player.func_184614_ca();
        ItemStack copy = itemstack.func_77946_l();
        boolean flag1 = state.canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)player);
        itemstack.func_179548_a(world, state, pos, (PlayerEntity)player);
        if (itemstack.func_190926_b() && !copy.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copy, (Hand)Hand.MAIN_HAND);
        }
        if ((flag = MiscUtil.removeBlock(world, pos, player, flag1)) && flag1) {
            ItemStack itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
            block.func_180657_a(world, (PlayerEntity)player, pos, state, tileentity, itemstack1);
        }
        if (flag && exp > 0) {
            state.func_177230_c().func_180637_b(world, pos, exp);
        }
        return true;
    }

    private static boolean removeBlock(World world, BlockPos pos, ServerPlayerEntity player, boolean canHarvest) {
        BlockState state = world.func_180495_p(pos);
        boolean removed = state.removedByPlayer(world, pos, (PlayerEntity)player, canHarvest, world.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)world, pos, state);
        }
        return removed;
    }
}

