/*
 * Decompiled with CFR 0.152.
 */
package uniquee.api;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.IForgeRegistryEntry;
import uniquee.enchantments.IToggleEnchantment;

public class BaseUEMod {
    List<IToggleEnchantment> enchantments = new ObjectArrayList();
    public ForgeConfigSpec config;

    public void init(IEventBus bus, String name) {
        bus.addGenericListener(Enchantment.class, this::loadEnchantments);
        bus.addListener(this::onLoad);
        bus.addListener(this::onFileChange);
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("general");
        this.addConfig(builder);
        int m = this.enchantments.size();
        for (int i = 0; i < m; ++i) {
            this.enchantments.get(i).loadFromConfig(builder);
        }
        builder.pop();
        this.config = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, this.config, name);
    }

    protected void addConfig(ForgeConfigSpec.Builder builder) {
    }

    protected Enchantment register(Enchantment ench) {
        if (ench instanceof IToggleEnchantment) {
            this.enchantments.add((IToggleEnchantment)ench);
        }
        return ench;
    }

    protected void reloadConfig() {
        int m = this.enchantments.size();
        for (int i = 0; i < m; ++i) {
            this.enchantments.get(i).onConfigChanged();
        }
    }

    public void onLoad(ModConfig.Loading configEvent) {
        this.reloadConfig();
    }

    public void onFileChange(ModConfig.Reloading configEvent) {
        this.reloadConfig();
    }

    public void loadEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.enchantments.toArray(new Enchantment[this.enchantments.size()]));
    }
}

