/*
 * Decompiled with CFR 0.152.
 */
package uniquee.api.crops;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import uniquee.api.crops.CropsHarvester;
import uniquee.api.crops.ICropHarvest;

public class CropHarvestRegistry {
    public static CropHarvestRegistry INSTANCE = new CropHarvestRegistry();
    Map<Block, ICropHarvest> harvesters = new Object2ObjectOpenHashMap();

    public void init() {
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof CropsBlock)) continue;
            this.register(block, new CropsHarvester((CropsBlock)block));
        }
    }

    public void register(Block block, ICropHarvest harvest) {
        this.harvesters.put(block, harvest);
    }

    public boolean isValid(Block block) {
        return this.harvesters.containsKey(block);
    }

    public ActionResultType tryHarvest(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        ICropHarvest harvest = this.harvesters.get(state.func_177230_c());
        if (harvest != null) {
            ActionResult<ItemStack> result = harvest.harvest(state, world, pos);
            if (result.func_188397_a() == ActionResultType.FAIL) {
                return ActionResultType.FAIL;
            }
            if (result.func_188397_a() == ActionResultType.PASS) {
                return ActionResultType.PASS;
            }
            ItemStack stack = ((ItemStack)result.func_188398_b()).func_77946_l();
            if (!stack.func_190926_b()) {
                stack.func_190920_e(1);
            }
            player.func_71005_bN().func_174894_a(stack);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }
}

