/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.simple;

import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.ForgeConfigSpec;
import uniquee.enchantments.IToggleEnchantment;
import uniquee.enchantments.UniqueEnchantment;
import uniquee.utils.DoubleStat;

public class AdvancedDamageEnchantment
extends DamageEnchantment
implements IToggleEnchantment {
    public static final UniqueEnchantment.DefaultData[] DATA = new UniqueEnchantment.DefaultData[]{new UniqueEnchantment.DefaultData("all", Enchantment.Rarity.VERY_RARE, 5, true, 20, 2, 18), new UniqueEnchantment.DefaultData("undead", Enchantment.Rarity.RARE, 5, true, 16, 2, 14), new UniqueEnchantment.DefaultData("arthropods", Enchantment.Rarity.RARE, 5, true, 16, 2, 14)};
    private static final DoubleStat[] DEFAULTS = new DoubleStat[]{new DoubleStat(1.0, "scalar"), new DoubleStat(3.0, "scalar"), new DoubleStat(3.0, "scalar")};
    UniqueEnchantment.DefaultData values;
    public DoubleStat scalar;
    ForgeConfigSpec.BooleanValue isEnabled;

    public AdvancedDamageEnchantment(int damageTypeIn) {
        super(DATA[damageTypeIn].getRarity(), damageTypeIn, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        this.setRegistryName(DATA[damageTypeIn].getName());
        this.values = DATA[damageTypeIn];
        this.scalar = DEFAULTS[damageTypeIn];
    }

    public float func_152376_a(int level, CreatureAttribute creatureType) {
        switch (this.field_77361_a) {
            case 0: {
                return (float)(this.scalar.get() * (double)level);
            }
            case 1: {
                return creatureType == CreatureAttribute.field_223223_b_ ? (float)(this.scalar.get() * (double)level) : 0.0f;
            }
            case 2: {
                return creatureType == CreatureAttribute.field_223224_c_ ? (float)(this.scalar.get() * (double)level) : 0.0f;
            }
        }
        return 0.0f;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)this.isEnabled.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)this.isEnabled.get();
    }

    public String func_77320_a() {
        return "enchantment.uniquee." + this.values.getName();
    }

    public boolean func_185261_e() {
        return this.values.isTreasure();
    }

    public int func_77321_a(int enchantmentLevel) {
        return this.values.getLevelCost(enchantmentLevel);
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + this.values.getRangeCost();
    }

    public Enchantment.Rarity func_77324_c() {
        return this.values.getRarity();
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        if (target instanceof LivingEntity) {
            LivingEntity entitylivingbase = (LivingEntity)target;
            if (this.field_77361_a == 2 && entitylivingbase.func_70668_bt() == CreatureAttribute.field_223224_c_) {
                int i = 40 + user.func_70681_au().nextInt(15 * level);
                entitylivingbase.func_195064_c(new EffectInstance(Effects.field_76421_d, i, 3));
            }
        }
    }

    @Override
    public String getConfigName() {
        switch (this.field_77361_a) {
            case 0: {
                return "base.ameliorated_sharpness";
            }
            case 1: {
                return "base.ameliorated_smite";
            }
            case 2: {
                return "base.ameliorated_arthropods";
            }
        }
        return "I_AM_ERROR";
    }

    @Override
    public void loadFromConfig(ForgeConfigSpec.Builder entry) {
        entry.push(this.getConfigName());
        this.isEnabled = entry.define("enabled", true);
        this.values.loadConfig(entry);
        this.scalar.handleConfig(entry);
        entry.pop(2);
    }
}

