/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.UniqueEnchantment;
import uniquee.utils.DoubleStat;
import uniquee.utils.IntStat;
import uniquee.utils.MiscUtil;

public class ClimateTranquilityEnchantment
extends UniqueEnchantment {
    public static UUID SPEED_UUID = UUID.fromString("7b8a3791-8f94-4127-82b2-26418679d551");
    public static DoubleStat SPEED_SCALE = new DoubleStat(0.1, "speed_scale");
    public static IntStat SLOW_TIME = new IntStat(30, "slow_time");
    public static UUID ATTACK_UUID = UUID.fromString("b47bd399-5ad0-4f1d-a0eb-0a9146ff1734");
    public static DoubleStat ATTACK_SCALE = new DoubleStat(0.1, "attack_scale");
    public static IntStat BURN_TIME = new IntStat(1, "burn_time");

    public ClimateTranquilityEnchantment() {
        super(new UniqueEnchantment.DefaultData("climate_tranquility", Enchantment.Rarity.RARE, 3, true, 20, 2, 12), EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND, EquipmentSlotType.OFFHAND});
    }

    @Override
    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof AxeItem || EnchantmentType.BOW.func_77557_a(stack.func_77973_b());
    }

    @Override
    public void loadData(ForgeConfigSpec.Builder config) {
        SPEED_SCALE.handleConfig(config);
        SLOW_TIME.handleConfig(config);
        ATTACK_SCALE.handleConfig(config);
        BURN_TIME.handleConfig(config);
    }

    public static void onClimate(PlayerEntity player) {
        Object2IntMap.Entry<EquipmentSlotType> slot = MiscUtil.getEnchantedItem(UniqueEnchantments.CLIMATE_TRANQUILITY, (LivingEntity)player);
        ModifiableAttributeInstance speed = player.func_110148_a(Attributes.field_233825_h_);
        ModifiableAttributeInstance damage = player.func_110148_a(Attributes.field_233823_f_);
        if (slot.getIntValue() <= 0) {
            speed.func_188479_b(SPEED_UUID);
            damage.func_188479_b(ATTACK_UUID);
            return;
        }
        int level = slot.getIntValue();
        Set effects = BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)player.field_70170_p.func_226691_t_(player.func_233580_cy_()).getRegistryName()));
        boolean hasHot = effects.contains(BiomeDictionary.Type.HOT) || effects.contains(BiomeDictionary.Type.NETHER);
        boolean hasCold = effects.contains(BiomeDictionary.Type.COLD);
        if (hasHot && !hasCold) {
            AttributeModifier speedMod = new AttributeModifier(SPEED_UUID, "Climate Boost", SPEED_SCALE.get() * (double)level, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (!speed.func_180374_a(speedMod)) {
                speed.func_233769_c_(speedMod);
            }
        } else {
            speed.func_188479_b(SPEED_UUID);
        }
        if (hasCold && !hasHot) {
            AttributeModifier damageMod = new AttributeModifier(ATTACK_UUID, "Climate Boost", ATTACK_SCALE.get() * (double)level, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (!damage.func_180374_a(damageMod)) {
                damage.func_233769_c_(damageMod);
            }
        } else {
            damage.func_188479_b(ATTACK_UUID);
        }
    }
}

