/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import uniquee.enchantments.UniqueEnchantment;
import uniquee.utils.HarvestEntry;

public class DemetersSoulEnchantment
extends UniqueEnchantment {
    public static final String ID = "crop_queue";
    public static final String QUEUE_INDEX = "index_queue";

    public DemetersSoulEnchantment() {
        super(new UniqueEnchantment.DefaultData("demeters_soul", Enchantment.Rarity.VERY_RARE, 1, true, 20, 6, 40), EnchantmentType.BREAKABLE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND, EquipmentSlotType.OFFHAND});
    }

    @Override
    public void loadData(ForgeConfigSpec.Builder config) {
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)this.enabled.get() != false && stack.func_77973_b() instanceof HoeItem;
    }

    public static HarvestEntry getNextIndex(PlayerEntity player) {
        CompoundNBT entityData = player.getPersistentData();
        CompoundNBT persistent = entityData.func_74775_l("PlayerPersisted");
        ListNBT list = persistent.func_150295_c(ID, 10);
        if (list.isEmpty()) {
            return null;
        }
        int index = (persistent.func_74762_e(QUEUE_INDEX) + 1) % list.size();
        persistent.func_74768_a(QUEUE_INDEX, index);
        return new HarvestEntry(list.func_150305_b(index));
    }

    public static ListNBT getCrops(PlayerEntity player) {
        CompoundNBT entityData = player.getPersistentData();
        CompoundNBT persistent = entityData.func_74775_l("PlayerPersisted");
        entityData.func_218657_a("PlayerPersisted", (INBT)persistent);
        ListNBT list = persistent.func_150295_c(ID, 10);
        persistent.func_218657_a(ID, (INBT)list);
        return list;
    }
}

