/*
 * Decompiled with CFR 0.152.
 */
package uniquee.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.MapBanner;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import uniquee.UniqueEnchantments;
import uniquee.api.crops.CropHarvestRegistry;
import uniquee.enchantments.complex.EnderMendingEnchantment;
import uniquee.enchantments.complex.MomentumEnchantment;
import uniquee.enchantments.complex.PerpetualStrikeEnchantment;
import uniquee.enchantments.complex.SmartAssEnchantment;
import uniquee.enchantments.complex.SpartanWeaponEnchantment;
import uniquee.enchantments.complex.SwiftBladeEnchantment;
import uniquee.enchantments.curse.DeathsOdiumEnchantment;
import uniquee.enchantments.curse.PestilencesOdiumEnchantment;
import uniquee.enchantments.simple.BerserkEnchantment;
import uniquee.enchantments.simple.BoneCrusherEnchantment;
import uniquee.enchantments.simple.FocusImpactEnchantment;
import uniquee.enchantments.simple.RangeEnchantment;
import uniquee.enchantments.simple.SagesBlessingEnchantment;
import uniquee.enchantments.simple.SwiftEnchantment;
import uniquee.enchantments.simple.VitaeEnchantment;
import uniquee.enchantments.unique.AlchemistsGraceEnchantment;
import uniquee.enchantments.unique.AresBlessingEnchantment;
import uniquee.enchantments.unique.ClimateTranquilityEnchantment;
import uniquee.enchantments.unique.CloudwalkerEnchantment;
import uniquee.enchantments.unique.DemetersSoulEnchantment;
import uniquee.enchantments.unique.EcologicalEnchantment;
import uniquee.enchantments.unique.EnderMarksmenEnchantment;
import uniquee.enchantments.unique.FastFoodEnchantment;
import uniquee.enchantments.unique.IcarusAegisEnchantment;
import uniquee.enchantments.unique.NaturesGraceEnchantment;
import uniquee.enchantments.unique.WarriorsGraceEnchantment;
import uniquee.handler.ai.SpecialFindPlayerAI;
import uniquee.utils.HarvestEntry;
import uniquee.utils.MiscUtil;
import uniquee.utils.Triple;

public class EntityEvents {
    public static final Method ARROW_STACK = MiscUtil.findMethod(AbstractArrowEntity.class, new String[]{"getArrowStack", "func_184550_j"}, new Class[0]);
    public static final EntityEvents INSTANCE = new EntityEvents();
    List<Tuple<Enchantment, String[]>> tooltips = new ObjectArrayList();
    List<Triple<Enchantment, ToIntFunction<ItemStack>, String>> anvilHelpers = new ObjectArrayList();
    static final ThreadLocal<UUID> ENDER_MEN_TELEPORT = new ThreadLocal();

    public void registerStorageTooltip(Enchantment ench, String translation, String tag) {
        this.tooltips.add((Tuple<Enchantment, String[]>)new Tuple((Object)ench, (Object)new String[]{translation, tag}));
    }

    public void registerAnvilHelper(Enchantment ench, ToIntFunction<ItemStack> helper, String tag) {
        this.anvilHelpers.add(Triple.create(ench, helper, tag));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onToolTipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(stack);
        int m = this.tooltips.size();
        for (int i = 0; i < m; ++i) {
            Tuple<Enchantment, String[]> entry = this.tooltips.get(i);
            if (enchantments.getInt(entry.func_76341_a()) <= 0) continue;
            String[] names = (String[])entry.func_76340_b();
            event.getToolTip().add(new TranslationTextComponent(names[0], new Object[]{EntityEvents.getInt(stack, names[1], 0)}).func_240699_a_(TextFormatting.GOLD));
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EndermanEntity) {
            GoalSelector goals = ((EndermanEntity)entity).field_70715_bh;
            for (PrioritizedGoal goal : new ObjectArrayList((Collection)MiscUtil.findField(GoalSelector.class, goals, Set.class, "goals", "field_220892_d"))) {
                if (goal.func_220770_h() != 1 || !(goal.func_220772_j() instanceof NearestAttackableTargetGoal)) continue;
                goals.func_85156_a(goal.func_220772_j());
                goals.func_75776_a(1, (Goal)new SpecialFindPlayerAI((EndermanEntity)entity));
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        int level;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        if (event.side.isServer()) {
            CompoundNBT data;
            ItemStack stack2;
            int level2;
            int level3;
            if (player.func_110143_aJ() < player.func_110138_aP() && (level3 = MiscUtil.getEnchantmentLevel(UniqueEnchantments.NATURES_GRACE, player.func_184582_a(EquipmentSlotType.CHEST))) > 0 && player.field_70170_p.func_82737_E() % (long)Math.max(1, MathHelper.func_76128_c((double)Math.sqrt(NaturesGraceEnchantment.DELAY.get() / level3))) == 0L && player.func_110142_aN().func_94550_c() == null && EntityEvents.hasBlockCount(player.field_70170_p, player.func_233580_cy_(), 4, NaturesGraceEnchantment.FLOWERS)) {
                player.func_70691_i(NaturesGraceEnchantment.HEALING.getAsFloat(level3));
            }
            if (player.field_70170_p.func_82737_E() % 100L == 0L) {
                EquipmentSlotType[] slots = MiscUtil.getEquipmentSlotsFor(UniqueEnchantments.ENDER_MENDING);
                for (int i = 0; i < slots.length; ++i) {
                    int stored;
                    ItemStack stack3 = player.func_184582_a(slots[i]);
                    int level4 = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ENDER_MENDING, stack3);
                    if (level4 <= 0 || !stack3.func_77951_h() || (stored = EntityEvents.getInt(stack3, "ender_mending", 0)) <= 0) continue;
                    int toRemove = Math.min(stack3.func_77952_i(), stored);
                    stack3.func_196085_b(stack3.func_77952_i() - toRemove);
                    EntityEvents.setInt(stack3, "ender_mending", stored - toRemove);
                }
            }
            if (player.field_70170_p.func_82737_E() % 30L == 0L) {
                ClimateTranquilityEnchantment.onClimate(player);
            }
            if (player.field_70170_p.func_82737_E() % 10L == 0L && (level2 = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ICARUS_AEGIS, stack2 = player.func_184582_a(EquipmentSlotType.CHEST))) > 0) {
                stack2.func_77978_p().func_74757_a(IcarusAegisEnchantment.FLYING_TAG, player.func_184613_cA());
            }
            if (player.field_70170_p.func_82737_E() % 40L == 0L && (level3 = MiscUtil.getCombinedEnchantmentLevel(UniqueEnchantments.PESTILENCES_ODIUM, (LivingEntity)player)) > 0) {
                List living = player.field_70170_p.func_217357_a(AgeableEntity.class, new AxisAlignedBB(player.func_233580_cy_()).func_186662_g(PestilencesOdiumEnchantment.RADIUS.get()));
                int m = living.size();
                for (int i = 0; i < m; ++i) {
                    ((AgeableEntity)living.get(i)).func_195064_c(new EffectInstance(UniqueEnchantments.PESTILENCES_ODIUM_POTION, 200, level3));
                }
            }
            if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                HarvestEntry entry = DemetersSoulEnchantment.getNextIndex(player);
                if (entry != null) {
                    ActionResultType result = entry.harvest(player.field_70170_p, player);
                    if (result == ActionResultType.FAIL) {
                        ListNBT list = DemetersSoulEnchantment.getCrops(player);
                        int m = list.size();
                        for (int i = 0; i < m; ++i) {
                            if (!entry.matches(list.func_150305_b(i))) continue;
                            list.remove(i--);
                            break;
                        }
                    } else if (result == ActionResultType.SUCCESS) {
                        player.func_71020_j(0.06f);
                    }
                }
                if (this.isMining(player) && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ALCHEMISTS_GRACE, player.func_184614_ca())) > 0) {
                    AlchemistsGraceEnchantment.applyToEntity((Entity)player);
                }
                if ((level = MiscUtil.getEnchantedItem(UniqueEnchantments.SAGES_BLESSING, (LivingEntity)player)).getIntValue() > 0) {
                    player.func_71020_j(0.01f * (float)level.getIntValue());
                }
            }
            if ((data = event.player.getPersistentData()).func_74764_b("curse_regain_damage") && data.func_74763_f("curse_regain_timer") < event.player.field_70170_p.func_82737_E()) {
                ModifiableAttributeInstance instance;
                AttributeModifier mod;
                float total = data.func_74760_g("curse_regain_damage");
                if (total > 0.0f && (mod = (instance = event.player.func_110148_a(Attributes.field_233818_a_)).func_111127_a(DeathsOdiumEnchantment.REMOVE_UUID)) != null) {
                    float newValue = (float)Math.max(0.0, mod.func_111164_d() - (double)total);
                    instance.func_111124_b(mod);
                    if (newValue > 0.0f) {
                        instance.func_233769_c_(new AttributeModifier(DeathsOdiumEnchantment.REMOVE_UUID, "odiums_curse", (double)newValue, AttributeModifier.Operation.ADDITION));
                    }
                }
                data.func_82580_o("curse_regain_damage");
            }
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.CLOUD_WALKER, stack = player.func_184582_a(EquipmentSlotType.FEET))) > 0) {
            CompoundNBT nbt = player.getPersistentData();
            if (player.func_225608_bj_() && !nbt.func_74767_n("cloud_trigger") && (!player.func_233570_aj_() || nbt.func_74767_n("cloud_enabled"))) {
                nbt.func_74757_a("cloud_enabled", !nbt.func_74767_n("cloud_enabled"));
                nbt.func_74757_a("cloud_trigger", true);
            } else if (!player.func_225608_bj_()) {
                nbt.func_74757_a("cloud_trigger", false);
            }
            if (nbt.func_74767_n("cloud_enabled")) {
                int value = EntityEvents.getInt(stack, "cloud", CloudwalkerEnchantment.TICKS.get(level));
                if (value <= 0) {
                    nbt.func_74757_a("cloud_enabled", false);
                    return;
                }
                Vector3d vec = player.func_213322_ci();
                player.func_213293_j(vec.field_72450_a, player.field_71075_bZ.field_75100_b ? 0.15 : 0.0, vec.field_72449_c);
                player.func_225503_b_(player.field_70143_R, 1.0f);
                player.field_70143_R = 0.0f;
                if (!player.func_184812_l_()) {
                    EntityEvents.setInt(stack, "cloud", value - 1);
                    if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                        stack.func_222118_a(1, (LivingEntity)player, MiscUtil.get(EquipmentSlotType.FEET));
                    }
                }
            } else {
                EntityEvents.setInt(stack, "cloud", CloudwalkerEnchantment.TICKS.get(level));
            }
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.SWIFT, player.func_184582_a(EquipmentSlotType.LEGS))) > 0 && player.func_70617_f_() && player.field_191988_bg != 0.0f && player.func_213322_ci().func_82617_b() > 0.0 && player.func_213322_ci().func_82617_b() <= 0.2 && !player.func_225608_bj_()) {
            player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, SwiftEnchantment.SPEED_BONUS.getAsDouble(level) * 3.0, 0.0));
        }
        Boolean cache = null;
        EquipmentSlotType[] slots = MiscUtil.getEquipmentSlotsFor(UniqueEnchantments.ECOLOGICAL);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack equipStack = player.func_184582_a(slots[i]);
            level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ECOLOGICAL, equipStack);
            if (level <= 0 || !equipStack.func_77951_h() || player.field_70170_p.func_82737_E() % (long)Math.max(1, (int)((double)EcologicalEnchantment.SPEED.get() / Math.sqrt((double)level / EcologicalEnchantment.SCALE.get()))) != 0L || !(cache == null ? (cache = Boolean.valueOf(EntityEvents.hasBlockCount(player.field_70170_p, player.func_233580_cy_(), 1, EcologicalEnchantment.STATES))) != false : cache != false)) continue;
            equipStack.func_222118_a(-1, (LivingEntity)player, MiscUtil.get(slots[i]));
        }
    }

    @SubscribeEvent
    public void onXPPickup(PlayerXpEvent.PickupXp event) {
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        int maxLevel = 0;
        Object2BooleanLinkedOpenHashMap values = new Object2BooleanLinkedOpenHashMap();
        int foundItems = 0;
        EquipmentSlotType[] slots = MiscUtil.getEquipmentSlotsFor(UniqueEnchantments.ENDER_MENDING);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack stack = player.func_184582_a(slots[i]);
            if (stack.func_190926_b()) continue;
            int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ENDER_MENDING, stack);
            if (level > 0) {
                values.put((Object)stack, true);
                ++foundItems;
                maxLevel = Math.max(maxLevel, level);
                continue;
            }
            if (!stack.func_77951_h() || MiscUtil.getEnchantmentLevel(Enchantments.field_185296_A, stack) <= 0) continue;
            values.put((Object)stack, false);
        }
        if (values.isEmpty() || foundItems <= 0) {
            return;
        }
        int xp = event.getOrb().field_70530_e;
        int totalXP = (int)(((float)xp * 1.0f - EnderMendingEnchantment.ABSORBTION_RATIO.getAsFloat(maxLevel)) * 2.0f);
        xp -= totalXP / 2;
        int usedXP = 0;
        for (Object2BooleanMap.Entry entry : values.object2BooleanEntrySet()) {
            ItemStack stack = (ItemStack)entry.getKey();
            if (!stack.func_77951_h()) continue;
            int used = Math.min(totalXP - usedXP, stack.func_77952_i());
            stack.func_196085_b(stack.func_77952_i() - used);
            if ((usedXP += used) < totalXP) continue;
            break;
        }
        if (totalXP <= usedXP) {
            player.func_71001_a((Entity)event.getOrb(), 1);
            event.getOrb().func_70106_y();
            event.setCanceled(true);
            player.func_195068_e(xp);
            return;
        }
        totalXP -= usedXP;
        usedXP = 0;
        int perItem = Math.max(1, totalXP / foundItems);
        for (Object2BooleanMap.Entry entry : values.object2BooleanEntrySet()) {
            if (!entry.getBooleanValue()) continue;
            ItemStack stack = (ItemStack)entry.getKey();
            int stored = EntityEvents.getInt(stack, "ender_mending", 0);
            int left = Math.min(Math.min(totalXP - usedXP, perItem), EnderMendingEnchantment.LIMIT.get() - stored);
            if (left <= 0) continue;
            usedXP += left;
            EntityEvents.setInt(stack, "ender_mending", stored + left);
        }
        perItem = totalXP - usedXP;
        if (perItem > 0) {
            player.func_195068_e(perItem / 2);
        }
        player.func_71001_a((Entity)event.getOrb(), 1);
        event.getOrb().func_70106_y();
        event.setCanceled(true);
        player.func_195068_e(xp);
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        double value;
        if (event.getPlayer() == null) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184614_ca();
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.MOMENTUM, held);
        if (level > 0 && this.isMining(player)) {
            CompoundNBT nbt = player.getPersistentData();
            long worldTime = player.field_70170_p.func_82737_E();
            long time = nbt.func_74763_f("last_mined");
            int count = EntityEvents.getInt(held, "mined", 0);
            if (worldTime - time > (long)MomentumEnchantment.MAX_DELAY.get() || worldTime < time) {
                count = 0;
                EntityEvents.setInt(held, "mined", 0);
            }
            event.setNewSpeed(event.getNewSpeed() + event.getNewSpeed() * ((float)level * ((float)count / MomentumEnchantment.SCALAR.getFloat()) / event.getOriginalSpeed()));
            nbt.func_74772_a("last_mined", worldTime);
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.RANGE, held)) > 0 && (value = player.func_233638_c_((Attribute)ForgeMod.REACH_DISTANCE.get())) * value < player.func_195048_a(Vector3d.func_237491_b_((Vector3i)event.getPos()).func_72441_c(0.5, 0.5, 0.5))) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f - RangeEnchantment.REDUCTION.getDevided(level)));
        }
    }

    public boolean isMining(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            return MiscUtil.findField(PlayerInteractionManager.class, ((ServerPlayerEntity)player).field_71134_c, Boolean.class, "isDestroyingBlock", "field_73088_d");
        }
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack held = event.getPlayer().func_184614_ca();
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.SMART_ASS, held);
        if (level > 0 && SmartAssEnchantment.VALID_STATES.test(event.getState())) {
            Block block = event.getState().func_177230_c();
            int limit = SmartAssEnchantment.STATS.get(level);
            World world = (World)event.getWorld();
            BlockState lastState = null;
            BlockPos lastPos = null;
            for (int i = 1; i < limit; ++i) {
                BlockPos pos = event.getPos().func_177981_b(i);
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() != block) continue;
                lastState = state;
                lastPos = pos;
            }
            if (lastState != null && MiscUtil.harvestBlock(event, lastState, lastPos)) {
                event.setCanceled(true);
                return;
            }
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.SAGES_BLESSING, held)) > 0) {
            event.setExpToDrop((int)((double)event.getExpToDrop() + (double)event.getExpToDrop() * ((double)level * SagesBlessingEnchantment.XP_BOOST.get())));
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.MOMENTUM, held)) > 0) {
            int count;
            int old = count = EntityEvents.getInt(held, "mined", 0);
            count = Math.min(MomentumEnchantment.CAP.get() + level, count + 1);
            if (count != old) {
                EntityEvents.setInt(held, "mined", count);
            }
        }
    }

    @SubscribeEvent
    public void onItemClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (!event.getWorld().field_72995_K && stack.func_77973_b() instanceof FilledMapItem && MiscUtil.getEnchantmentLevel(UniqueEnchantments.ENDER_LIBRARIAN, stack) > 0) {
            MapData data = FilledMapItem.func_195950_a((ItemStack)stack, (World)event.getWorld());
            if (data == null || !data.field_76200_c.func_240901_a_().equals((Object)event.getWorld().func_234923_W_().func_240901_a_())) {
                return;
            }
            int x = data.field_76201_a;
            int z = data.field_76199_b;
            BlockPos position = null;
            CompoundNBT nbt = stack.func_77978_p();
            boolean isBanner = false;
            if (nbt != null) {
                ObjectArrayList banner;
                ListNBT list = nbt.func_150295_c("Decorations", 10);
                int m = list.size();
                for (int i = 0; i < m; ++i) {
                    CompoundNBT nbtData = list.func_150305_b(i);
                    if (!nbtData.func_74779_i("id").equalsIgnoreCase("+")) continue;
                    position = new BlockPos(nbtData.func_74762_e("x") - 20, 255, nbtData.func_74762_e("z") - 20);
                }
                if (position == null && (banner = new ObjectArrayList(MiscUtil.findField(MapData.class, data, Map.class, "banners", "field_204270_k").values())).size() > 0) {
                    position = ((MapBanner)banner.get(event.getWorld().field_73012_v.nextInt(banner.size()))).func_204304_a();
                    isBanner = true;
                }
            }
            if (position != null) {
                BlockPos pos = event.getWorld().func_205770_a(Heightmap.Type.MOTION_BLOCKING, position);
                event.getPlayer().func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)Math.max(isBanner ? 0 : event.getWorld().func_181545_F(), pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f));
            } else {
                int limit = 64 * (1 << data.field_76197_d) * 2;
                int xOffset = (int)((event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)limit);
                int zOffset = (int)((event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)limit);
                BlockPos pos = event.getWorld().func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(x + xOffset, 255, z + zOffset));
                event.getPlayer().func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)Math.max(event.getWorld().func_181545_F(), pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f));
            }
            stack.func_190918_g(1);
        }
    }

    @SubscribeEvent
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPlayer().func_225608_bj_()) {
            int level;
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            if (state.func_177230_c() instanceof AnvilBlock) {
                ItemStack stack = event.getItemStack();
                Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(stack);
                int m = this.anvilHelpers.size();
                for (int i = 0; i < m; ++i) {
                    int found;
                    Triple<Enchantment, ToIntFunction<ItemStack>, String> entry = this.anvilHelpers.get(i);
                    if (enchantments.getInt((Object)entry.getKey()) <= 0 || (found = EntityEvents.consumeItems(event.getPlayer(), entry.getValue(), Integer.MAX_VALUE)) <= 0) continue;
                    EntityEvents.setInt(stack, entry.getExtra(), found + EntityEvents.getInt(stack, entry.getExtra(), 0));
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    event.setCanceled(true);
                }
            }
            if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.DEMETERS_SOUL, event.getItemStack())) > 0 && CropHarvestRegistry.INSTANCE.isValid(state.func_177230_c()) && !event.getWorld().field_72995_K) {
                HarvestEntry entry = new HarvestEntry(event.getWorld().func_234923_W_().func_240901_a_(), event.getPos().func_218275_a());
                ListNBT list = DemetersSoulEnchantment.getCrops(event.getPlayer());
                boolean found = false;
                int m = list.size();
                for (int i = 0; i < m; ++i) {
                    if (!entry.matches(list.func_150305_b(i))) continue;
                    found = true;
                    list.remove(i--);
                    break;
                }
                if (!found) {
                    list.add((Object)entry.save());
                }
                event.getPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("tooltip.uniqee.crops." + (found ? "removed" : "added") + ".name"), false);
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityHit(LivingAttackEvent event) {
        Entity entity = event.getSource().func_76346_g();
        AlchemistsGraceEnchantment.applyToEntity(entity);
    }

    @SubscribeEvent
    public void onEntityAttack(LivingHurtEvent event) {
        double value;
        PlayerEntity player;
        ItemStack stack;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof LivingEntity) {
            ModifiableAttributeInstance attr;
            LivingEntity base = (LivingEntity)entity;
            Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(base.func_184614_ca());
            if (enchantments.getInt((Object)UniqueEnchantments.BERSERKER) > 0) {
                event.setAmount(event.getAmount() * (1.0f + BerserkEnchantment.SCALAR.getFloat() * (base.func_110138_aP() / Math.max(1.0f, base.func_110143_aJ()))));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.SWIFT_BLADE)) > 0 && (attr = base.func_110148_a(Attributes.field_233825_h_)) != null) {
                event.setAmount(event.getAmount() * (1.0f + (float)Math.log10(attr.func_111126_e() / SwiftBladeEnchantment.SCALAR.get() * (double)level)));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.FOCUS_IMPACT)) > 0 && (attr = base.func_110148_a(Attributes.field_233825_h_)) != null) {
                event.setAmount(event.getAmount() * (1.0f + (float)Math.log10(FocusImpactEnchantment.DAMAGE.get() * (double)level / (attr.func_111126_e() * attr.func_111126_e()))));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.PERPETUAL_STRIKE)) > 0) {
                ItemStack held = base.func_184614_ca();
                int count = EntityEvents.getInt(held, "strikes", 0);
                int lastEntity = EntityEvents.getInt(held, "hit_id", 0);
                if (lastEntity != event.getEntityLiving().func_145782_y()) {
                    count = 0;
                    EntityEvents.setInt(held, "hit_id", event.getEntityLiving().func_145782_y());
                }
                event.setAmount(event.getAmount() * (1.0f + (float)(level * count) * PerpetualStrikeEnchantment.SCALAR.getFloat()));
                EntityEvents.setInt(held, "strikes", count + 1);
            }
            if ((level = MiscUtil.getEnchantedItem(UniqueEnchantments.CLIMATE_TRANQUILITY, base).getIntValue()) > 0) {
                Set effects = BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)base.field_70170_p.func_226691_t_(base.func_233580_cy_()).getRegistryName()));
                boolean hasHot = effects.contains(BiomeDictionary.Type.HOT) || effects.contains(BiomeDictionary.Type.NETHER);
                boolean hasCold = effects.contains(BiomeDictionary.Type.COLD);
                if (hasHot && !hasCold) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76421_d, ClimateTranquilityEnchantment.SLOW_TIME.get() * level, level));
                } else if (hasCold && !hasHot) {
                    event.getEntityLiving().func_70015_d(level * ClimateTranquilityEnchantment.BURN_TIME.get());
                }
            }
            if (event.getEntityLiving() instanceof AbstractSkeletonEntity && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.BONE_CRUSH, base.func_184614_ca())) > 0 && BoneCrusherEnchantment.isNotArmored((AbstractSkeletonEntity)event.getEntityLiving())) {
                event.setAmount(event.getAmount() * (1.0f + BoneCrusherEnchantment.SCALAR.getFloat() * (float)level));
            }
        }
        if (entity instanceof PlayerEntity && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.RANGE, stack = (player = (PlayerEntity)entity).func_184614_ca())) > 0 && (value = player.func_233638_c_((Attribute)ForgeMod.REACH_DISTANCE.get())) * value < player.func_70068_e(event.getEntity())) {
            event.setAmount(event.getAmount() * (1.0f - RangeEnchantment.REDUCTION.getDevided(level)));
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingDamageEvent event) {
        CompoundNBT compound;
        int consume;
        int feathers;
        ItemStack stack;
        LivingEntity base;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof LivingEntity && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.SPARTAN_WEAPON, (base = (LivingEntity)entity).func_184614_ca())) > 0 && base.func_184592_cb().func_77973_b() instanceof ShieldItem) {
            event.setAmount(event.getAmount() + event.getAmount() * (SpartanWeaponEnchantment.SCALAR.getFloat() * (float)level));
        }
        if (event.getSource() == DamageSource.field_188406_j && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ICARUS_AEGIS, stack = event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST))) > 0 && (feathers = EntityEvents.getInt(stack, IcarusAegisEnchantment.FEATHER_TAG, 0)) >= (consume = (int)Math.ceil((double)IcarusAegisEnchantment.SCALAR.get() / (double)level))) {
            EntityEvents.setInt(stack, IcarusAegisEnchantment.FEATHER_TAG, feathers -= consume);
            event.setCanceled(true);
            return;
        }
        if (event.getAmount() >= event.getEntityLiving().func_110143_aJ()) {
            ItemStack stack2;
            int level2;
            DamageSource source = event.getSource();
            if (!source.func_82725_o() && source != DamageSource.field_76379_h && (level2 = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ARES_BLESSING, stack2 = event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST))) > 0 && stack2.func_77984_f()) {
                float damage = event.getAmount();
                stack2.func_222118_a((int)((double)damage * (AresBlessingEnchantment.SCALAR.get() / (double)level2)), event.getEntityLiving(), MiscUtil.get(EquipmentSlotType.CHEST));
                event.setCanceled(true);
                return;
            }
            Object2IntMap.Entry<EquipmentSlotType> slot = MiscUtil.getEnchantedItem(UniqueEnchantments.PHOENIX_BLESSING, event.getEntityLiving());
            if (slot.getIntValue() > 0) {
                LivingEntity living = event.getEntityLiving();
                living.func_70691_i(living.func_110138_aP());
                living.func_195061_cb();
                if (living instanceof PlayerEntity) {
                    ((PlayerEntity)living).func_71024_bL().func_75122_a(Short.MAX_VALUE, 1.0f);
                }
                living.getPersistentData().func_74772_a("curse_regain_timer", living.func_130014_f_().func_82737_E() + (long)DeathsOdiumEnchantment.DELAY.get());
                living.func_195064_c(new EffectInstance(Effects.field_76428_l, 600, 1));
                living.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
                living.field_70170_p.func_72960_a((Entity)living, (byte)35);
                event.getEntityLiving().func_184582_a((EquipmentSlotType)slot.getKey()).func_190918_g(1);
                event.setCanceled(true);
            }
        }
        if (entity instanceof MobEntity && (compound = entity.getPersistentData()).func_74763_f("curse_regain_timer") >= entity.field_70170_p.func_82737_E()) {
            compound.func_74776_a("curse_regain_damage", compound.func_74760_g("curse_regain_damage") + event.getAmount());
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        int consume;
        int feathers;
        ItemStack stack = event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST);
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ICARUS_AEGIS, stack);
        if (level > 0 && stack.func_77978_p().func_74767_n(IcarusAegisEnchantment.FLYING_TAG) && event.getDistance() > 3.0f && (feathers = EntityEvents.getInt(stack, IcarusAegisEnchantment.FEATHER_TAG, 0)) >= (consume = (int)Math.max(Math.ceil((double)IcarusAegisEnchantment.SCALAR.get() / (double)level), 4.0))) {
            EntityEvents.setInt(stack, IcarusAegisEnchantment.FEATHER_TAG, feathers -= consume);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        Object2IntMap.Entry<EquipmentSlotType> ench;
        ItemStack stack;
        int amount;
        LivingEntity base;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof LivingEntity && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.WARRIORS_GRACE, (base = (LivingEntity)entity).func_184614_ca())) > 0 && (amount = Math.min((stack = base.func_184614_ca()).func_77952_i(), MathHelper.func_76143_f((double)(Math.sqrt(event.getEntityLiving().func_110138_aP() * (float)level) * WarriorsGraceEnchantment.DURABILITY_GAIN.get())))) > 0) {
            stack.func_222118_a(-amount, base, MiscUtil.get(EquipmentSlotType.MAINHAND));
        }
        if ((ench = MiscUtil.getEnchantedItem(UniqueEnchantments.DEATHS_ODIUM, event.getEntityLiving())).getIntValue() > 0) {
            ItemStack stack2 = event.getEntityLiving().func_184582_a((EquipmentSlotType)ench.getKey());
            EntityEvents.setInt(stack2, "curse_storage", EntityEvents.getInt(stack2, "curse_storage", 0) + 1);
            ModifiableAttributeInstance instance = event.getEntityLiving().func_110148_a(Attributes.field_233818_a_);
            AttributeModifier mod = instance.func_111127_a(DeathsOdiumEnchantment.REMOVE_UUID);
            float toRemove = 0.0f;
            if (mod != null) {
                toRemove = (float)((double)toRemove + mod.func_111164_d());
                instance.func_111124_b(mod);
            }
            CompoundNBT nbt = event.getEntityLiving().getPersistentData().func_74775_l("PlayerPersisted");
            event.getEntityLiving().getPersistentData().func_218657_a("PlayerPersisted", (INBT)nbt);
            nbt.func_74776_a("curse_storage", toRemove - 1.0f);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.Clone event) {
        float f = event.getPlayer().getPersistentData().func_74775_l("PlayerPersisted").func_74760_g("curse_storage");
        if (f != 0.0f) {
            event.getEntityLiving().func_110148_a(Attributes.field_233818_a_).func_233767_b_(new AttributeModifier(DeathsOdiumEnchantment.REMOVE_UUID, "odiums_curse", (double)f, AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public void onXPDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        int level = MiscUtil.getEnchantedItem(UniqueEnchantments.SAGES_BLESSING, (LivingEntity)event.getAttackingPlayer()).getIntValue();
        if (level > 0) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() + (double)event.getDroppedExperience() * ((double)level * SagesBlessingEnchantment.XP_BOOST.get())));
        }
    }

    @SubscribeEvent
    public void onLootingLevel(LootingLevelEvent event) {
        int level;
        Entity entity = event.getDamageSource().func_76346_g();
        if (entity instanceof LivingEntity && event.getEntityLiving() instanceof AbstractSkeletonEntity && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.BONE_CRUSH, ((LivingEntity)entity).func_184614_ca())) > 0 && BoneCrusherEnchantment.isNotArmored((AbstractSkeletonEntity)event.getEntityLiving())) {
            event.setLootingLevel(event.getLootingLevel() + 1 + level);
        }
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        PlayerEntity base;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof PlayerEntity && event.getEntityLiving() instanceof AnimalEntity && (level = MiscUtil.getEnchantedItem(UniqueEnchantments.FAST_FOOD, (LivingEntity)(base = (PlayerEntity)entity)).getIntValue()) > 0) {
            base.func_71024_bL().func_75122_a(FastFoodEnchantment.NURISHMENT.get(level), FastFoodEnchantment.SATURATION.getFloat() * (float)level);
            event.setCanceled(true);
        }
        if (event.getEntityLiving().func_70644_a(UniqueEnchantments.PESTILENCES_ODIUM_POTION)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onArrowHit(ProjectileImpactEvent.Arrow event) {
        PlayerEntity player;
        Object2IntMap.Entry<EquipmentSlotType> slot;
        RayTraceResult result = event.getRayTraceResult();
        if (!(result instanceof EntityRayTraceResult)) {
            return;
        }
        AbstractArrowEntity arrow = event.getArrow();
        Entity shooter = arrow.func_234616_v_();
        AlchemistsGraceEnchantment.applyToEntity(shooter);
        if (shooter instanceof PlayerEntity && (slot = MiscUtil.getEnchantedItem(UniqueEnchantments.ENDERMARKSMEN, (LivingEntity)(player = (PlayerEntity)shooter))).getIntValue() > 0) {
            Entity entity;
            int level = slot.getIntValue();
            ItemStack stack = player.func_184582_a((EquipmentSlotType)slot.getKey());
            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
            player.func_191521_c(EntityEvents.getArrowStack(arrow));
            int needed = Math.min((int)((double)level * EnderMarksmenEnchantment.SCALAR.get()), stack.func_77952_i());
            if (needed > 0) {
                stack.func_222118_a(-needed, (LivingEntity)player, MiscUtil.get((EquipmentSlotType)slot.getKey()));
            }
            if ((entity = ((EntityRayTraceResult)result).func_216348_a()) instanceof EndermanEntity) {
                ENDER_MEN_TELEPORT.set(entity.func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public void onEndermenTeleport(EnderTeleportEvent event) {
        UUID id = ENDER_MEN_TELEPORT.get();
        if (event.getEntity().func_110124_au().equals(id)) {
            ENDER_MEN_TELEPORT.set(null);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEquippementSwapped(LivingEquipmentChangeEvent event) {
        AttributeModifierManager attribute = event.getEntityLiving().func_233645_dx_();
        Multimap<Attribute, AttributeModifier> mods = this.createModifiersFromStack(event.getFrom(), event.getSlot());
        if (!mods.isEmpty()) {
            attribute.func_233785_a_(mods);
        }
        if (!(mods = this.createModifiersFromStack(event.getTo(), event.getSlot())).isEmpty()) {
            attribute.func_233793_b_(mods);
        }
    }

    private Multimap<Attribute, AttributeModifier> createModifiersFromStack(ItemStack stack, EquipmentSlotType slot) {
        int value;
        HashMultimap mods = HashMultimap.create();
        Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(stack);
        int level = enchantments.getInt((Object)UniqueEnchantments.VITAE);
        if (level > 0 && MiscUtil.getSlotsFor(UniqueEnchantments.VITAE).contains(slot)) {
            mods.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(VitaeEnchantment.getForSlot(slot), "Vitae Boost", (double)level * VitaeEnchantment.HEALTH_BOOST.get(), AttributeModifier.Operation.ADDITION));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.SWIFT)) > 0 && MiscUtil.getSlotsFor(UniqueEnchantments.SWIFT).contains(slot)) {
            mods.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(SwiftEnchantment.SPEED_MOD, "Swift Boost", SwiftEnchantment.SPEED_BONUS.getAsDouble(level), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.RANGE)) > 0 && MiscUtil.getSlotsFor(UniqueEnchantments.RANGE).contains(slot)) {
            mods.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(RangeEnchantment.RANGE_MOD, "Range Boost", (double)RangeEnchantment.RANGE.getAsFloat(level), AttributeModifier.Operation.ADDITION));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.DEATHS_ODIUM)) > 0 && MiscUtil.getSlotsFor(UniqueEnchantments.DEATHS_ODIUM).contains(slot) && (value = EntityEvents.getInt(stack, "curse_storage", 0)) > 0) {
            mods.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(DeathsOdiumEnchantment.getForSlot(slot), "Death Odiums Restore", (double)value, AttributeModifier.Operation.ADDITION));
        }
        return mods;
    }

    public static int getInt(ItemStack stack, String tagName, int defaultValue) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt == null || !nbt.func_74764_b(tagName) ? defaultValue : nbt.func_74762_e(tagName);
    }

    public static void setInt(ItemStack stack, String tagName, int value) {
        stack.func_77983_a(tagName, (INBT)IntNBT.func_229692_a_((int)value));
    }

    public static long getLong(ItemStack stack, String tagName, long defaultValue) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt == null || !nbt.func_74764_b(tagName) ? defaultValue : nbt.func_74763_f(tagName);
    }

    public static void setLong(ItemStack stack, String tagName, long value) {
        stack.func_77983_a(tagName, (INBT)LongNBT.func_229698_a_((long)value));
    }

    public static void growStack(ItemStack source, int size, List<ItemStack> output) {
        while (size > 0) {
            ItemStack stack = source.func_77946_l();
            stack.func_190920_e(Math.min(size, stack.func_77976_d()));
            output.add(stack);
            size -= stack.func_190916_E();
        }
    }

    public static ItemStack getArrowStack(AbstractArrowEntity arrow) {
        try {
            return (ItemStack)ARROW_STACK.invoke((Object)arrow, new Object[0]);
        }
        catch (Exception exception) {
            if (arrow instanceof SpectralArrowEntity) {
                return new ItemStack((IItemProvider)Items.field_185166_h);
            }
            if (arrow instanceof ArrowEntity) {
                CompoundNBT nbt = new CompoundNBT();
                arrow.func_189511_e(nbt);
                if (nbt.func_74764_b("CustomPotionEffects")) {
                    ItemStack stack = new ItemStack((IItemProvider)Items.field_185167_i);
                    stack.func_77983_a("CustomPotionEffects", nbt.func_74781_a("CustomPotionEffects"));
                    return stack;
                }
                return new ItemStack((IItemProvider)Items.field_151032_g);
            }
            return ItemStack.field_190927_a;
        }
    }

    public static boolean isOre(BlockState state) {
        return Tags.Items.ORES.func_230235_a_((Object)state.func_177230_c().func_199767_j());
    }

    public static int consumeItems(PlayerEntity player, ToIntFunction<ItemStack> validator, int limit) {
        int found = 0;
        NonNullList inv = player.field_71071_by.field_70462_a;
        int m = inv.size();
        for (int i = 0; i < m; ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            int value = validator.applyAsInt(stack);
            if (value <= 0) continue;
            int left = limit - found;
            if (left >= stack.func_190916_E() * value) {
                found += stack.func_190916_E() * value;
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    inv.set(i, (Object)stack.func_77973_b().getContainerItem(stack));
                    continue;
                }
                inv.set(i, (Object)ItemStack.field_190927_a);
            } else if (left / value > 0) {
                stack.func_190918_g(left / value);
                found += left;
            }
            if (found >= limit) break;
        }
        return found;
    }

    public static boolean hasBlockCount(World world, BlockPos pos, int limit, Predicate<BlockState> validator) {
        BlockPos.Mutable newPos = new BlockPos.Mutable();
        int found = 0;
        for (int y = 0; y <= 1; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    newPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!validator.test(world.func_180495_p((BlockPos)newPos)) || ++found < limit) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getXP(PlayerEntity player) {
        return EntityEvents.getXPForLvl(player.field_71068_ca) + (int)(player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 15) {
            return level * level + 6 * level;
        }
        if (level <= 30) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    public static int getLvlForXP(int totalXP) {
        int result = 0;
        while (EntityEvents.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }
}

