/*
 * Decompiled with CFR 0.152.
 */
package uniquee.utils;

import net.minecraftforge.common.ForgeConfigSpec;

public class DoubleLevelStats {
    String name;
    final double baseConfig;
    final double levelConfig;
    ForgeConfigSpec.DoubleValue base;
    ForgeConfigSpec.DoubleValue level;

    public DoubleLevelStats(String name, double base, double level) {
        this.name = name;
        this.baseConfig = base;
        this.levelConfig = level;
    }

    public void handleConfig(ForgeConfigSpec.Builder config) {
        this.base = config.defineInRange(this.name + "_base", this.baseConfig, 0.0, Double.MAX_VALUE);
        this.level = config.defineInRange(this.name + "_level", this.levelConfig, 0.0, Double.MAX_VALUE);
    }

    public void handleConfig(ForgeConfigSpec.Builder config, String comment) {
        config.comment(comment);
        this.base = config.defineInRange(this.name + "_base", this.baseConfig, 0.0, Double.MAX_VALUE);
        this.level = config.defineInRange(this.name + "_level", this.levelConfig, 0.0, Double.MAX_VALUE);
    }

    public double getBase() {
        return this.base != null ? (Double)this.base.get() : this.baseConfig;
    }

    public double getLevel() {
        return this.level != null ? (Double)this.level.get() : this.levelConfig;
    }

    public double getAsDouble(int level) {
        return this.getBase() + this.getLevel() * (double)level;
    }

    public float getAsFloat(int level) {
        return (float)(this.getBase() + this.getLevel() * (double)level);
    }

    public float getDevided(int level) {
        return (float)(this.getBase() / (this.getLevel() * (double)level));
    }
}

