/*
 * Decompiled with CFR 0.152.
 */
package uniquee.utils;

import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import uniquee.api.crops.CropHarvestRegistry;

public class HarvestEntry {
    ResourceLocation dim;
    long position;

    public HarvestEntry(CompoundNBT nbt) {
        this(new ResourceLocation(nbt.func_74779_i("dim")), nbt.func_74763_f("pos"));
    }

    public HarvestEntry(ResourceLocation dim, long position) {
        this.dim = dim;
        this.position = position;
    }

    public boolean matches(CompoundNBT nbt) {
        return this.dim.toString().equals(nbt.func_74779_i("dim")) && this.position == nbt.func_74763_f("pos");
    }

    public CompoundNBT save() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("dim", this.dim.toString());
        compound.func_74772_a("pos", this.position);
        return compound;
    }

    public ActionResultType harvest(World world, PlayerEntity player) {
        if (!world.func_234923_W_().func_240901_a_().equals((Object)this.dim)) {
            return ActionResultType.PASS;
        }
        BlockPos pos = BlockPos.func_218283_e((long)this.position);
        return world.func_195588_v(pos) ? CropHarvestRegistry.INSTANCE.tryHarvest(world.func_180495_p(pos), world, pos, player) : ActionResultType.PASS;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.dim);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HarvestEntry) {
            HarvestEntry entry = (HarvestEntry)obj;
            return entry.dim == this.dim && entry.position == this.position;
        }
        return false;
    }
}

