/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.vm.block;

import com.lupicus.vm.block.RotateContainerBase;
import com.lupicus.vm.config.MyConfig;
import com.lupicus.vm.item.ModItems;
import com.lupicus.vm.tileentity.VendingMachineTileEntity;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class VendingMachine
extends RotateContainerBase {
    public static final BooleanProperty BOTTOM = BlockStateProperties.field_222513_b;
    private TileEntity saveTE;
    private BlockState saveState;

    public VendingMachine(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a()).func_196953_a(context)) {
            return null;
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)context.func_195992_f());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            TileEntity te;
            if (!((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
                pos = pos.func_177977_b();
            }
            if ((te = worldIn.func_175625_s(pos)) instanceof VendingMachineTileEntity) {
                ((VendingMachineTileEntity)te).openGui(player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            TileEntity te;
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(false)), 3);
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null && (te = worldIn.func_175625_s(pos)) instanceof VendingMachineTileEntity) {
                ((VendingMachineTileEntity)te).readMined(tag);
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos pos2;
        if (!worldIn.field_72995_K && state.func_177230_c() != newState.func_177230_c() && worldIn.func_180495_p(pos2 = pos.func_177972_a((Boolean)state.func_177229_b((IProperty)BOTTOM) != false ? Direction.UP : Direction.DOWN)).func_177230_c() == this) {
            worldIn.func_180501_a(pos2, Blocks.field_150350_a.func_176223_P(), 3);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        boolean flag;
        boolean bl = flag = !world.field_72995_K;
        if (flag) {
            this.saveTE = null;
            if (!((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
                this.saveMainBlock((IBlockReader)world, pos);
            }
        }
        boolean removed = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!(!flag || removed && willHarvest)) {
            this.saveTE = null;
        }
        return removed;
    }

    public boolean canDropFromExplosion(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        if (world instanceof ServerWorld) {
            this.saveTE = null;
            if (!((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
                this.saveMainBlock(world, pos);
            }
        }
        return true;
    }

    private void saveMainBlock(IBlockReader world, BlockPos pos) {
        BlockPos blockpos = pos.func_177972_a(Direction.DOWN);
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && ((Boolean)blockstate.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            this.saveTE = world.func_175625_s(blockpos);
            this.saveState = blockstate;
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity entity;
        if (this.saveTE != null) {
            builder.func_216021_b(LootParameters.field_216288_h, (Object)this.saveTE);
            state = this.saveState;
            this.saveTE = null;
        }
        if (!MyConfig.minable) {
            return Collections.emptyList();
        }
        List ret = super.func_220076_a(state, builder);
        if (!ret.isEmpty() && (entity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h)) instanceof VendingMachineTileEntity) {
            VendingMachineTileEntity vte = (VendingMachineTileEntity)entity;
            for (ItemStack e : ret) {
                if (e.func_77973_b() != ModItems.VENDING_MACHINE) continue;
                CompoundNBT tag = e.func_196082_o();
                vte.writeMined(tag);
            }
        }
        return ret;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BOTTOM);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new VendingMachineTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HORIZONTAL_FACING, BOTTOM});
    }
}

