/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.vm.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="vm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static boolean restock;
    public static boolean fixed;
    public static boolean minable;
    public static HashSet<Item> excludeItemSet;
    public static HashSet<String> excludeModSet;
    public static HashSet<String> includeModSet;
    public static HashSet<String> excludeGroupSet;
    public static HashSet<String> includeGroupSet;
    public static HashMap<Item, Rarity> itemRarityMap;
    public static int commonCost;
    public static int uncommonCost;
    public static int rareCost;
    public static int epicCost;
    public static int commonUses;
    public static int uncommonUses;
    public static int rareUses;
    public static int epicUses;
    public static Item commonItem;
    public static Item uncommonItem;
    public static Item rareItem;
    public static Item epicItem;
    public static boolean[] fixedExtended;
    public static Item[] fixedItems;
    public static int[] fixedAmount;
    public static int[] fixedUses;
    public static ItemStack[] fixedPayment;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        restock = (Boolean)MyConfig.COMMON.restock.get();
        fixed = (Boolean)MyConfig.COMMON.fixed.get();
        minable = (Boolean)MyConfig.COMMON.minable.get();
        commonCost = (Integer)MyConfig.COMMON.commonCost.get();
        uncommonCost = (Integer)MyConfig.COMMON.uncommonCost.get();
        rareCost = (Integer)MyConfig.COMMON.rareCost.get();
        epicCost = (Integer)MyConfig.COMMON.epicCost.get();
        commonUses = (Integer)MyConfig.COMMON.commonUses.get();
        uncommonUses = (Integer)MyConfig.COMMON.uncommonUses.get();
        rareUses = (Integer)MyConfig.COMMON.rareUses.get();
        epicUses = (Integer)MyConfig.COMMON.epicUses.get();
        commonItem = MyConfig.getItem((String)MyConfig.COMMON.commonItem.get());
        uncommonItem = MyConfig.getItem((String)MyConfig.COMMON.uncommonItem.get());
        rareItem = MyConfig.getItem((String)MyConfig.COMMON.rareItem.get());
        epicItem = MyConfig.getItem((String)MyConfig.COMMON.epicItem.get());
        MyConfig.extractFixed(MyConfig.extract((String)MyConfig.COMMON.fixedItems.get()));
        includeModSet = MyConfig.stringSet(MyConfig.extract((String)MyConfig.COMMON.includeMods.get()));
        excludeModSet = MyConfig.stringSet(MyConfig.extract((String)MyConfig.COMMON.excludeMods.get()));
        excludeItemSet = MyConfig.itemSet(MyConfig.extract((String)MyConfig.COMMON.excludeItems.get()));
        includeGroupSet = MyConfig.stringSet(MyConfig.extract((String)MyConfig.COMMON.includeGroups.get()));
        excludeGroupSet = MyConfig.stringSet(MyConfig.extract((String)MyConfig.COMMON.excludeGroups.get()));
        itemRarityMap = MyConfig.itemMap(MyConfig.extract((String)MyConfig.COMMON.itemRarity.get()));
        MyConfig.validateMods(includeModSet, "IncludeMods");
        MyConfig.validateMods(excludeModSet, "ExcludeMods");
        MyConfig.validateGroups(includeGroupSet, "IncludeGroups");
        MyConfig.validateGroups(excludeGroupSet, "ExcludeGroups");
    }

    private static Item getItem(String name) {
        Item ret = Items.field_151166_bC;
        try {
            ResourceLocation key = new ResourceLocation(name);
            if (ForgeRegistries.ITEMS.containsKey(key)) {
                ret = (Item)ForgeRegistries.ITEMS.getValue(key);
            } else {
                LOGGER.warn("Unknown item: " + name);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Bad item: " + name);
        }
        return ret;
    }

    private static void extractFixed(String[] values) {
        for (int i = 0; i < fixedItems.length; ++i) {
            MyConfig.fixedExtended[i] = false;
            MyConfig.fixedItems[i] = Items.field_190931_a;
            if (i >= values.length) continue;
            try {
                ResourceLocation key;
                String[] part = values[i].split(",");
                if (part.length == 5) {
                    MyConfig.fixedExtended[i] = true;
                    MyConfig.fixedUses[i] = commonUses;
                    MyConfig.fixedPayment[i] = new ItemStack((IItemProvider)commonItem, commonCost);
                    MyConfig.fixedAmount[i] = 1;
                    key = new ResourceLocation(part[0]);
                    if (ForgeRegistries.ITEMS.containsKey(key)) {
                        MyConfig.fixedItems[i] = (Item)ForgeRegistries.ITEMS.getValue(key);
                    } else {
                        LOGGER.warn("Unknown item: " + key.toString());
                    }
                    MyConfig.fixedAmount[i] = Integer.parseInt(part[1]);
                    key = new ResourceLocation(part[2]);
                    if (ForgeRegistries.ITEMS.containsKey(key)) {
                        Item payItem = (Item)ForgeRegistries.ITEMS.getValue(key);
                        int cost = Integer.parseInt(part[3]);
                        MyConfig.fixedPayment[i] = new ItemStack((IItemProvider)payItem, cost);
                    } else {
                        LOGGER.warn("Unknown item: " + key.toString());
                    }
                    MyConfig.fixedUses[i] = Integer.parseInt(part[4]);
                    continue;
                }
                if (part.length != 1) {
                    LOGGER.warn("Bad number of subfields: ", (Object)values[i]);
                }
                if (ForgeRegistries.ITEMS.containsKey(key = new ResourceLocation(part[0]))) {
                    MyConfig.fixedItems[i] = (Item)ForgeRegistries.ITEMS.getValue(key);
                    continue;
                }
                LOGGER.warn("Unknown item: " + key.toString());
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("Bad entry: " + values[i]);
            }
        }
    }

    private static HashSet<String> stringSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            set.add(values[i].trim());
        }
        return set;
    }

    private static HashSet<Item> itemSet(String[] values) {
        HashSet<Item> ret = new HashSet<Item>();
        IForgeRegistry reg = ForgeRegistries.ITEMS;
        for (String name : values) {
            List<String> list = MyConfig.expandItem(name);
            for (String entry : list) {
                try {
                    ResourceLocation key = new ResourceLocation(entry);
                    if (reg.containsKey(key)) {
                        Item item = (Item)reg.getValue(key);
                        ret.add(item);
                        continue;
                    }
                    LOGGER.warn("Unknown entry in ExcludeItems: " + entry);
                }
                catch (Exception e) {
                    LOGGER.warn("Bad entry in ExcludeItems: " + entry);
                }
            }
        }
        return ret;
    }

    private static HashMap<Item, Rarity> itemMap(String[] values) {
        HashMap<Item, Rarity> ret = new HashMap<Item, Rarity>();
        IForgeRegistry reg = ForgeRegistries.ITEMS;
        for (String name : values) {
            Rarity rarity = Rarity.COMMON;
            int i = name.indexOf(61);
            if (i < 0) {
                LOGGER.warn("Bad entry in ItemRarity: " + name);
                continue;
            }
            String part1 = name.substring(0, i).trim();
            String part2 = name.substring(i + 1).trim();
            if (!part2.isEmpty()) {
                try {
                    int j = Integer.parseInt(part2);
                    if (j == 1) {
                        rarity = Rarity.UNCOMMON;
                    } else if (j == 2) {
                        rarity = Rarity.RARE;
                    } else if (j >= 3) {
                        rarity = Rarity.EPIC;
                    }
                }
                catch (Exception j) {
                    // empty catch block
                }
            }
            if (part1.endsWith(":*")) {
                MyConfig.expandMod((IForgeRegistry<Item>)reg, ret, part1.substring(0, part1.length() - 2), rarity);
                continue;
            }
            List<String> list = MyConfig.expandItem(part1);
            for (String entry : list) {
                try {
                    ResourceLocation key = new ResourceLocation(entry);
                    if (reg.containsKey(key)) {
                        Item item = (Item)reg.getValue(key);
                        ret.put(item, rarity);
                        continue;
                    }
                    LOGGER.warn("Unknown entry in ItemRarity: " + entry);
                }
                catch (Exception e) {
                    LOGGER.warn("Bad entry in ItemRarity: " + entry);
                }
            }
        }
        return ret;
    }

    private static String[] extract(String value) {
        String[] ret = value.split(";");
        return ret;
    }

    private static void validateMods(HashSet<String> set, String configName) {
        ModList list = ModList.get();
        set.removeIf(name -> {
            if (name.equals("*")) {
                return false;
            }
            if (list.isLoaded(name)) {
                return false;
            }
            LOGGER.warn("Unknown entry in " + configName + ": " + name);
            return true;
        });
    }

    private static void validateGroups(HashSet<String> set, String configName) {
        HashSet<String> groups = new HashSet<String>();
        for (ItemGroup g : ItemGroup.field_78032_a) {
            if (g == ItemGroup.field_192395_m || g == ItemGroup.field_78027_g || g == ItemGroup.field_78036_m) continue;
            groups.add(g.func_200300_c());
        }
        set.removeIf(name -> {
            if (name.equals("*")) {
                return false;
            }
            if (name.equals("!")) {
                return false;
            }
            if (groups.contains(name)) {
                return false;
            }
            LOGGER.warn("Unknown entry in " + configName + ": " + name);
            return true;
        });
    }

    private static List<String> expandItem(String name) {
        ArrayList<String> ret;
        block12: {
            block10: {
                String temp;
                String ns;
                block13: {
                    block11: {
                        ret = new ArrayList<String>();
                        ret.add(name);
                        int i = name.indexOf(58);
                        if (i < 0 || name.indexOf(42) <= 0) break block10;
                        ns = name.substring(0, i + 1);
                        temp = name.substring(i + 1);
                        if (!temp.startsWith("toolset*")) break block11;
                        String type = temp.substring(8);
                        ret.clear();
                        ret.add(ns + type + "_sword");
                        ret.add(ns + type + "_shovel");
                        ret.add(ns + type + "_pickaxe");
                        ret.add(ns + type + "_axe");
                        ret.add(ns + type + "_hoe");
                        break block12;
                    }
                    if (!temp.startsWith("armorset*")) break block13;
                    String type = temp.substring(9);
                    ret.clear();
                    ret.add(ns + type + "_helmet");
                    ret.add(ns + type + "_chestplate");
                    ret.add(ns + type + "_leggings");
                    ret.add(ns + type + "_boots");
                    break block12;
                }
                if (!temp.startsWith("colorset*")) break block12;
                String type = temp.substring(9);
                ret.clear();
                for (DyeColor dye : DyeColor.values()) {
                    ret.add(ns + dye.toString() + "_" + type);
                }
                break block12;
            }
            if (name.startsWith("eggset*")) {
                String mode = name.substring(7);
                if (mode.equals("all")) {
                    ret.clear();
                    for (SpawnEggItem e : SpawnEggItem.func_195985_g()) {
                        ResourceLocation res = e.getRegistryName();
                        ret.add(res.toString());
                    }
                } else if (mode.equals("monster")) {
                    ret.clear();
                    for (SpawnEggItem e : SpawnEggItem.func_195985_g()) {
                        EntityType type = e.func_208076_b(null);
                        if (type.func_220339_d().func_75599_d()) continue;
                        ResourceLocation res = e.getRegistryName();
                        ret.add(res.toString());
                    }
                } else if (mode.equals("peaceful")) {
                    ret.clear();
                    for (SpawnEggItem e : SpawnEggItem.func_195985_g()) {
                        EntityType type = e.func_208076_b(null);
                        if (!type.func_220339_d().func_75599_d()) continue;
                        ResourceLocation res = e.getRegistryName();
                        ret.add(res.toString());
                    }
                }
            }
        }
        return ret;
    }

    private static void expandMod(IForgeRegistry<Item> reg, HashMap<Item, Rarity> map, String name, Rarity newRarity) {
        if (!ModList.get().isLoaded(name)) {
            LOGGER.warn("Unknown mod entry in ItemRarity: " + name);
            return;
        }
        for (Map.Entry entry : reg.getEntries()) {
            if (!name.equals(((ResourceLocation)entry.getKey()).func_110624_b())) continue;
            Item item = (Item)entry.getValue();
            Rarity rarity = map.get(item);
            if (rarity == null) {
                rarity = item.func_77613_e(new ItemStack((IItemProvider)item));
            }
            if (rarity == newRarity) continue;
            map.put(item, newRarity);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        fixedExtended = new boolean[7];
        fixedItems = new Item[7];
        fixedAmount = new int[7];
        fixedUses = new int[7];
        fixedPayment = new ItemStack[7];
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue restock;
        public final ForgeConfigSpec.BooleanValue fixed;
        public final ForgeConfigSpec.BooleanValue minable;
        public final ForgeConfigSpec.ConfigValue<String> commonItem;
        public final ForgeConfigSpec.ConfigValue<String> uncommonItem;
        public final ForgeConfigSpec.ConfigValue<String> rareItem;
        public final ForgeConfigSpec.ConfigValue<String> epicItem;
        public final ForgeConfigSpec.IntValue commonCost;
        public final ForgeConfigSpec.IntValue uncommonCost;
        public final ForgeConfigSpec.IntValue rareCost;
        public final ForgeConfigSpec.IntValue epicCost;
        public final ForgeConfigSpec.IntValue commonUses;
        public final ForgeConfigSpec.IntValue uncommonUses;
        public final ForgeConfigSpec.IntValue rareUses;
        public final ForgeConfigSpec.IntValue epicUses;
        public final ForgeConfigSpec.ConfigValue<String> fixedItems;
        public final ForgeConfigSpec.ConfigValue<String> includeMods;
        public final ForgeConfigSpec.ConfigValue<String> excludeMods;
        public final ForgeConfigSpec.ConfigValue<String> excludeItems;
        public final ForgeConfigSpec.ConfigValue<String> includeGroups;
        public final ForgeConfigSpec.ConfigValue<String> excludeGroups;
        public final ForgeConfigSpec.ConfigValue<String> itemRarity;

        public Common(ForgeConfigSpec.Builder builder) {
            String baseTrans = "vm.config.";
            String sectionTrans = baseTrans + "general.";
            this.restock = builder.comment("Restock").translation(sectionTrans + "restock").define("Restock", true);
            this.fixed = builder.comment("Use fixed items").translation(sectionTrans + "use_fixed").define("UseFixedItems", false);
            this.minable = builder.comment("Minable").translation(sectionTrans + "minable").define("Minable", false);
            this.fixedItems = builder.comment("Fixed items; item or item,amount,pay_item,cost,uses").translation(sectionTrans + "fixed_items").define("FixedItems", (Object)"minecraft:air;minecraft:air;minecraft:air;minecraft:air;minecraft:air;minecraft:air;minecraft:air");
            this.includeMods = builder.comment("Include Mods").translation(sectionTrans + "include_mods").define("IncludeMods", (Object)"*");
            this.excludeMods = builder.comment("Exclude Mods").translation(sectionTrans + "exclude_mods").define("ExcludeMods", (Object)"draconicevolution;avaritia;botania");
            this.excludeItems = builder.comment("Exclude Items").translation(sectionTrans + "exclude_items").define("ExcludeItems", (Object)"minecraft:nether_star;minecraft:beacon;minecraft:bedrock;minecraft:shulker_box;minecraft:colorset*shulker_box;minecraft:elytra;minecraft:end_portal_frame;minecraft:armorset*netherite;minecraft:toolset*netherite;minecraft:netherite_block;minecraft:netherite_ingot;vm:vending_machine");
            this.includeGroups = builder.comment("Include Creative Tab Groups").translation(sectionTrans + "include_groups").define("IncludeGroups", (Object)"*");
            this.excludeGroups = builder.comment("Exclude Creative Tab Groups").translation(sectionTrans + "exclude_groups").define("ExcludeGroups", (Object)"!");
            this.itemRarity = builder.comment("Change item rarity value for pricing").translation(sectionTrans + "item_rarity").define("ItemRarity", (Object)"minecraft:emerald_block=1;minecraft:diamond_block=1;minecraft:armorset*diamond=1;minecraft:toolset*diamond=1;minecraft:anvil=2;minecraft:trident=3;minecraft:bell=2;minecraft:conduit=3;minecraft:nautilus_shell=1;eggset*peaceful=1;eggset*monster=2;minecraft:evoker_spawn_egg=3;minecraft:netherite_scrap=2;minecraft:ancient_debris=2");
            builder.push("RarityData");
            sectionTrans = baseTrans + ".rarity.";
            this.commonItem = builder.comment("Common Item").translation(sectionTrans + "common_item").define("CommonItem", (Object)"minecraft:emerald");
            this.uncommonItem = builder.comment("Uncommon Item").translation(sectionTrans + "uncommon_item").define("UncommonItem", (Object)"minecraft:emerald");
            this.rareItem = builder.comment("Rare Item").translation(sectionTrans + "rare_item").define("RareItem", (Object)"minecraft:emerald");
            this.epicItem = builder.comment("Epic Item").translation(sectionTrans + "epic_item").define("EpicItem", (Object)"minecraft:emerald");
            this.commonCost = builder.comment("Common Cost").translation(sectionTrans + "common_cost").defineInRange("CommonCost", 1, 0, 64);
            this.uncommonCost = builder.comment("Uncommon Cost").translation(sectionTrans + "uncommon_cost").defineInRange("UncommonCost", 16, 0, 64);
            this.rareCost = builder.comment("Rare Cost").translation(sectionTrans + "rare_cost").defineInRange("RareCost", 32, 0, 64);
            this.epicCost = builder.comment("Epic Cost").translation(sectionTrans + "epic_cost").defineInRange("EpicCost", 64, 0, 64);
            this.commonUses = builder.comment("Common Uses").translation(sectionTrans + "common_uses").defineInRange("CommonUses", 8, 0, 32);
            this.uncommonUses = builder.comment("Uncommon Uses").translation(sectionTrans + "uncommon_uses").defineInRange("UncommonUses", 4, 0, 32);
            this.rareUses = builder.comment("Rare Uses").translation(sectionTrans + "rare_uses").defineInRange("RareUses", 2, 0, 32);
            this.epicUses = builder.comment("Epic Uses").translation(sectionTrans + "epic_uses").defineInRange("EpicUses", 1, 0, 32);
            builder.pop();
        }
    }
}

