/*
 * Decompiled with CFR 0.152.
 */
package wards.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import wards.Wards;
import wards.WardsConfig;
import wards.block.WardTileEntity;

public class WardBlock
extends ContainerBlock {
    private static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape RAISED_BASE = Block.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    private static final VoxelShape PILLAR = Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{RAISED_BASE, PILLAR});
    public static final BooleanProperty ADMIN_MODE = BooleanProperty.func_177716_a((String)"admin_mode");
    private Map<String, Integer> powerSources = new HashMap<String, Integer>();

    public WardBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)ADMIN_MODE, (Comparable)Boolean.valueOf(false)));
        for (String s : (List)WardsConfig.powerSources.get()) {
            String[] data = s.split("-");
            if (data.length == 2) {
                this.powerSources.put(data[0], Integer.valueOf(data[1]));
                continue;
            }
            Wards.LOGGER.warn("Warning: invalid token in powerSources config option: " + s);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult raytraceresult) {
        TileEntity tileentity;
        if (!world.field_72995_K && (tileentity = world.func_175625_s(pos)) instanceof WardTileEntity) {
            ItemStack item = player.func_184586_b(hand);
            String registryName = item.func_77973_b().getRegistryName().toString();
            if (!((Boolean)state.func_177229_b((IProperty)ADMIN_MODE)).booleanValue() || player.func_195070_dx()) {
                if (this.powerSources.containsKey(registryName)) {
                    ((WardTileEntity)tileentity).addFuel(this.powerSources.get(registryName), true);
                    if (!player.func_184812_l_()) {
                        item.func_190918_g(1);
                    }
                } else if (((List)WardsConfig.acceptedItems.get()).contains(item.func_77973_b().getRegistryName().toString())) {
                    ItemStack newBook = item.func_77946_l();
                    newBook.func_190920_e(1);
                    if (((WardTileEntity)tileentity).replaceBook(newBook, pos) && !player.func_184812_l_()) {
                        item.func_190918_g(1);
                    }
                } else if (item.func_77973_b() == Items.field_221747_dJ) {
                    world.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)ADMIN_MODE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)ADMIN_MODE) == false)));
                } else {
                    ((WardTileEntity)tileentity).dropBook();
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof WardTileEntity && !((WardTileEntity)te).getBook().func_190926_b()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((WardTileEntity)te).getBook());
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)ADMIN_MODE)).booleanValue()) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new WardTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_220081_d(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ADMIN_MODE});
    }
}

