/*
 * Decompiled with CFR 0.152.
 */
package wards.block;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import wards.WardsConfig;
import wards.WardsRegistryManager;
import wards.block.WardBlock;
import wards.function.WardEnchantmentType;

public class WardTileEntity
extends TileEntity
implements ITickableTileEntity {
    private ItemStack book = ItemStack.field_190927_a;
    private int power = 0;
    private int maxPower = 100000;
    private boolean canWard = true;
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookSpread;
    public float bookSpreadPrev;
    public float bookRotation;
    public float bookRotationPrev;
    public float tRot;

    public WardTileEntity() {
        super(WardsRegistryManager.ward_te);
    }

    public void func_73660_a() {
        Random rand = this.func_145831_w().func_201674_k();
        this.updateBookRotation();
        boolean adminMode = (Boolean)this.func_195044_w().func_177229_b((IProperty)WardBlock.ADMIN_MODE);
        if (adminMode) {
            this.setFuel(this.maxPower);
        }
        if (!this.getBook().func_190926_b() && this.power > 0) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)this.getBook());
            Enchantment primaryEnchant = null;
            Enchantment secondaryEnchant = null;
            int primaryEnchantLevel = 0;
            for (Map.Entry entry : enchants.entrySet()) {
                if (primaryEnchant == null) {
                    primaryEnchant = (Enchantment)entry.getKey();
                    primaryEnchantLevel = (Integer)entry.getValue();
                } else if (secondaryEnchant == null) {
                    secondaryEnchant = (Enchantment)entry.getKey();
                }
                if ((Integer)entry.getValue() <= primaryEnchantLevel) continue;
                secondaryEnchant = primaryEnchant;
                primaryEnchant = (Enchantment)entry.getKey();
                primaryEnchantLevel = (Integer)entry.getValue();
            }
            int range = Math.min(5 + 3 * Math.min(4, primaryEnchantLevel), 15);
            BlockPos pos1 = this.func_174877_v().func_177982_a(-range, -range, -range);
            BlockPos pos2 = this.func_174877_v().func_177982_a(range, range, range);
            AxisAlignedBB wardArea = new AxisAlignedBB(pos1, pos2);
            this.canWard = true;
            int redstoneStrength = this.func_145831_w().func_175676_y(this.func_174877_v());
            if (!adminMode) {
                if (redstoneStrength >= 12) {
                    this.canWard = false;
                } else {
                    for (BlockPos pos : BlockPos.func_218278_a((BlockPos)pos1, (BlockPos)pos2)) {
                        if (pos.equals((Object)this.func_174877_v()) || this.func_145831_w().func_180495_p(pos) != WardsRegistryManager.ward.func_176223_P() || !(this.func_145831_w().func_175625_s(pos) instanceof WardTileEntity) || ((WardTileEntity)this.func_145831_w().func_175625_s((BlockPos)pos)).power <= 0 || ((WardTileEntity)this.func_145831_w().func_175625_s(pos)).getBook().func_190926_b()) continue;
                        this.canWard = false;
                        if (this.func_145831_w().func_82737_E() % 20L != 0L || !this.func_145831_w().field_72995_K) continue;
                        double xDiff = (double)(pos.func_177958_n() - this.func_174877_v().func_177958_n()) / 14.0;
                        double yDiff = (double)(pos.func_177956_o() - this.func_174877_v().func_177956_o()) / 14.0;
                        double zDiff = (double)(pos.func_177952_p() - this.func_174877_v().func_177952_p()) / 14.0;
                        int i = 0;
                        while ((double)i <= 14.0) {
                            double xCoord = (double)this.func_174877_v().func_177958_n() + xDiff * (double)i + 0.5;
                            double yCoord = (double)this.func_174877_v().func_177956_o() + yDiff * (double)i + 0.5;
                            double zCoord = (double)this.func_174877_v().func_177952_p() + zDiff * (double)i + 0.5;
                            this.func_145831_w().func_195590_a((IParticleData)RedstoneParticleData.field_197564_a, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                            ++i;
                        }
                    }
                }
            }
            if (this.canWard && primaryEnchant != null) {
                double zCoord;
                double yCoord;
                double xCoord;
                double zDiff;
                double yDiff;
                WardEnchantmentType wardType = WardEnchantmentType.fromEnchant(primaryEnchant);
                WardEnchantmentType wardType2 = null;
                if (secondaryEnchant != null) {
                    wardType2 = WardEnchantmentType.fromEnchant(secondaryEnchant);
                }
                if (this.func_145831_w().func_82737_E() % (long)wardType.getInterval() == 0L) {
                    List entities = this.func_145831_w().func_217357_a(LivingEntity.class, wardArea);
                    for (LivingEntity target : entities) {
                        if (!this.canSeeTarget(this, (Entity)target)) continue;
                        if (this.func_145831_w().field_72995_K) {
                            double xDiff = (target.func_226277_ct_() - (double)this.func_174877_v().func_177958_n() - 0.5) / 14.0;
                            yDiff = (target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f) - (double)this.func_174877_v().func_177956_o() + 0.5) / 14.0;
                            zDiff = (target.func_226281_cx_() - (double)this.func_174877_v().func_177952_p() - 0.5) / 14.0;
                            int i = 0;
                            while ((double)i <= 14.0) {
                                xCoord = (double)this.func_174877_v().func_177958_n() + xDiff * (double)i + 0.5;
                                yCoord = (double)this.func_174877_v().func_177956_o() + yDiff * (double)i + 0.5;
                                zCoord = (double)this.func_174877_v().func_177952_p() + zDiff * (double)i + 0.5;
                                if (target instanceof IMob && redstoneStrength == 0) {
                                    for (IParticleData particle : wardType.getParticles()) {
                                        this.func_145831_w().func_195590_a(particle, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                                        this.func_145831_w().func_195590_a(particle, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                                    }
                                } else if (target instanceof PlayerEntity) {
                                    this.func_145831_w().func_195590_a((IParticleData)ParticleTypes.field_197623_p, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                                    this.func_145831_w().func_195590_a((IParticleData)ParticleTypes.field_197623_p, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                                }
                                ++i;
                            }
                        }
                        if (target instanceof IMob && redstoneStrength == 0) {
                            wardType.expelMagic(this, target, primaryEnchantLevel);
                            this.subtractFuel(35);
                            continue;
                        }
                        if (!(target instanceof PlayerEntity)) continue;
                        wardType.empowerPlayer(this, (PlayerEntity)target, primaryEnchantLevel);
                        this.subtractFuel(35);
                    }
                }
                if (this.func_145831_w().func_82737_E() % 40L == 0L && rand.nextBoolean() && this.func_145831_w().field_72995_K) {
                    for (int i = 0; i < 5 * primaryEnchantLevel; ++i) {
                        for (IParticleData particle : wardType.getParticles()) {
                            double xCoord2 = (double)this.func_174877_v().func_177958_n() + 0.5 + 0.25 * (rand.nextDouble() - rand.nextDouble());
                            double zCoord2 = (double)this.func_174877_v().func_177952_p() + 0.5 + 0.25 * (rand.nextDouble() - rand.nextDouble());
                            double yCoord2 = (double)this.func_174877_v().func_177956_o() + 0.85;
                            this.func_145831_w().func_195590_a(particle, true, xCoord2, yCoord2, zCoord2, 0.0, 0.0, 0.0);
                            this.func_145831_w().func_195590_a(particle, true, xCoord2, yCoord2, zCoord2, 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (wardType2 != null && (double)this.func_145831_w().func_82737_E() % ((double)wardType2.getInterval() * 1.5) == 0.0) {
                    List entities = this.func_145831_w().func_217357_a(LivingEntity.class, wardArea);
                    for (LivingEntity target : entities) {
                        if (this.canSeeTarget(this, (Entity)target) && this.func_145831_w().field_72995_K) {
                            double xDiff = (target.func_226277_ct_() - (double)this.func_174877_v().func_177958_n() - 0.5) / 14.0;
                            yDiff = (target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f) - ((double)this.func_174877_v().func_177956_o() + 0.5)) / 14.0;
                            zDiff = (target.func_226281_cx_() - (double)this.func_174877_v().func_177952_p() - 0.5) / 14.0;
                            int i = 0;
                            while ((double)i <= 14.0) {
                                xCoord = (double)this.func_174877_v().func_177958_n() + xDiff * (double)i + 0.5;
                                yCoord = (double)this.func_174877_v().func_177956_o() + yDiff * (double)i + 0.5;
                                zCoord = (double)this.func_174877_v().func_177952_p() + zDiff * (double)i + 0.5;
                                if (target instanceof IMob && redstoneStrength == 0) {
                                    for (IParticleData particle : wardType2.getParticles()) {
                                        this.func_145831_w().func_195590_a(particle, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                                        this.func_145831_w().func_195590_a(particle, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                                    }
                                } else if (target instanceof PlayerEntity) {
                                    this.func_145831_w().func_195590_a((IParticleData)ParticleTypes.field_197623_p, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                                    this.func_145831_w().func_195590_a((IParticleData)ParticleTypes.field_197623_p, true, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
                                }
                                ++i;
                            }
                        }
                        if (target instanceof IMob && redstoneStrength == 0) {
                            wardType.expelMagic(this, target, primaryEnchantLevel);
                            continue;
                        }
                        if (!(target instanceof PlayerEntity)) continue;
                        wardType.empowerPlayer(this, (PlayerEntity)target, primaryEnchantLevel);
                    }
                }
            }
        }
    }

    public boolean canSeeTarget(WardTileEntity ward, Entity entity) {
        return this.canSeeTargetFromSide(Direction.NORTH, entity) || this.canSeeTargetFromSide(Direction.EAST, entity) || this.canSeeTargetFromSide(Direction.SOUTH, entity) || this.canSeeTargetFromSide(Direction.WEST, entity) || this.canSeeTargetFromSide(Direction.UP, entity);
    }

    public boolean canSeeTargetFromSide(Direction direction, Entity entity) {
        Vec3d wardVec = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        Vec3d entityEyeVec = new Vec3d(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
        Vec3d entityFootVec = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        wardVec = wardVec.func_72441_c((double)direction.func_82601_c() * 0.4, (double)direction.func_96559_d() * 0.4, (double)direction.func_82599_e() * 0.4);
        return this.func_145831_w().func_217299_a(new RayTraceContext(wardVec, entityEyeVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() == RayTraceResult.Type.MISS || this.func_145831_w().func_217299_a(new RayTraceContext(wardVec, entityFootVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    public void updateBookRotation() {
        float f2;
        Random rand = this.func_145831_w().func_201674_k();
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation;
        this.tRot += 0.02f;
        this.bookSpread = this.canWard || this.getBook().func_77973_b() == Items.field_151122_aG ? (this.bookSpread += 0.1f) : (this.bookSpread -= 0.1f);
        if (this.bookSpread < 0.5f || rand.nextInt(40) == 0) {
            float f1 = this.flipT;
            do {
                this.flipT += (float)(rand.nextInt(4) - rand.nextInt(4));
            } while (f1 == this.flipT);
        }
        while (this.bookRotation >= (float)Math.PI) {
            this.bookRotation -= (float)Math.PI * 2;
        }
        while (this.bookRotation < (float)(-Math.PI)) {
            this.bookRotation += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.bookRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.bookRotation += f2 * 0.4f;
        this.bookSpread = this.getBook().func_77973_b() != Items.field_151122_aG ? MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)(1.0f * (float)((double)this.power / (double)this.maxPower))) : MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)1.0f);
        ++this.tickCount;
        this.pageFlipPrev = this.pageFlip;
        float f = (this.flipT - this.pageFlip) * 0.4f;
        f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
    }

    public ItemStack getBook() {
        return this.book;
    }

    private void setBook(ItemStack book) {
        this.book = book;
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        this.func_145831_w().func_225319_b(this.func_174877_v(), this.func_195044_w(), this.func_195044_w());
    }

    public boolean replaceBook(ItemStack stack, BlockPos pos) {
        if (this.getBook().func_190926_b()) {
            if (((List)WardsConfig.acceptedItems.get()).contains(stack.func_77973_b().getRegistryName().toString())) {
                this.setBook(stack);
                return true;
            }
        } else {
            this.dropBook();
        }
        return false;
    }

    public void dropBook() {
        if (!this.getBook().func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.book);
            this.setBook(ItemStack.field_190927_a);
        }
    }

    public int getFuel() {
        return this.power;
    }

    public boolean setFuel(int value) {
        if (value <= this.maxPower) {
            this.power = value;
            return true;
        }
        return false;
    }

    public void subtractFuel(int value) {
        this.setFuel(Math.max(0, this.getFuel() - value));
    }

    public boolean addFuel(int value, boolean fillToMax) {
        int temp = this.power + value;
        if (temp <= this.maxPower) {
            this.power = temp;
            this.func_70296_d();
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            this.func_145831_w().func_225319_b(this.func_174877_v(), this.func_195044_w(), this.func_195044_w());
            return true;
        }
        if (fillToMax) {
            this.power = this.maxPower;
            this.func_70296_d();
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            this.func_145831_w().func_225319_b(this.func_174877_v(), this.func_195044_w(), this.func_195044_w());
            return true;
        }
        return false;
    }

    public boolean canWard() {
        return this.canWard;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("power")) {
            this.power = compound.func_74762_e("power");
        }
        if (compound.func_74764_b("canWard")) {
            this.canWard = compound.func_74767_n("canWard");
        }
        if (compound.func_74764_b("book")) {
            this.book = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("book"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("power", this.power);
        compound.func_74757_a("canWard", this.canWard);
        compound.func_218657_a("book", (INBT)this.getBook().func_77955_b(new CompoundNBT()));
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        this.func_145831_w().func_225319_b(this.func_174877_v(), this.func_195044_w(), this.func_195044_w());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }
}

