/*
 * Decompiled with CFR 0.152.
 */
package wards.function;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import wards.WardsConfig;
import wards.WardsRegistryManager;
import wards.block.WardTileEntity;

public class WardEnchantmentType {
    private IParticleData[] particles;
    private String name;
    private int interval;
    public static final WardEnchantmentType COMBAT = new WardEnchantmentType("Combat", 80, new IParticleData[]{ParticleTypes.field_197614_g, ParticleTypes.field_197590_A});
    public static final WardEnchantmentType FORTITUDE = new WardEnchantmentType("Fortitude", 80, new IParticleData[]{ParticleTypes.field_197623_p, ParticleTypes.field_197590_A});
    public static final WardEnchantmentType FIRE = new WardEnchantmentType("Fire", 80, new IParticleData[]{ParticleTypes.field_197631_x, ParticleTypes.field_197617_j, ParticleTypes.field_218423_k});
    public static final WardEnchantmentType WATER = new WardEnchantmentType("Water", 80, new IParticleData[]{ParticleTypes.field_197618_k, ParticleTypes.field_218425_n, ParticleTypes.field_218422_X});
    public static final WardEnchantmentType LUCK = new WardEnchantmentType("Luck", 80, new IParticleData[]{ParticleTypes.field_197632_y, ParticleTypes.field_197623_p});
    public static final WardEnchantmentType DESTRUCTION = new WardEnchantmentType("Destruction", 140, new IParticleData[]{ParticleTypes.field_197609_b, ParticleTypes.field_197613_f});
    public static final WardEnchantmentType SLAYER = new WardEnchantmentType("Slayer", 120, new IParticleData[]{ParticleTypes.field_197614_g, ParticleTypes.field_197622_o});
    public static final WardEnchantmentType HASTE = new WardEnchantmentType("Haste", 60, new IParticleData[]{ParticleTypes.field_197620_m, ParticleTypes.field_197598_I});
    public static final WardEnchantmentType KNOWLEDGE = new WardEnchantmentType("Knowledge", 100, new IParticleData[]{ParticleTypes.field_197623_p, ParticleTypes.field_197623_p});
    public static final WardEnchantmentType CURSE = new WardEnchantmentType("Curse", 100, new IParticleData[]{ParticleTypes.field_197596_G, ParticleTypes.field_197605_P, ParticleTypes.field_197599_J});

    public WardEnchantmentType(String name, int interval, IParticleData ... particles) {
        this.name = name;
        this.particles = particles;
        this.interval = interval;
    }

    public String getName() {
        return this.name;
    }

    public int getInterval() {
        return this.interval;
    }

    public IParticleData[] getParticles() {
        return this.particles;
    }

    public void expelMagic(WardTileEntity ward, LivingEntity entity, int level) {
        if (!entity.func_130014_f_().field_72995_K) {
            if (this == COMBAT) {
                entity.func_70097_a(DamageSource.field_76376_m, 1.0f + 0.5f * (float)(level - 1));
            } else if (this == FORTITUDE) {
                entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 25 * level, Math.min(level, 3)));
            } else if (this == FIRE) {
                entity.func_70015_d(level * 2);
            } else if (this == WATER) {
                entity.func_70097_a(DamageSource.field_76376_m, 0.5f + 0.25f * (float)(level - 1));
                if (entity.func_203008_ap()) {
                    entity.func_70097_a(DamageSource.field_76376_m, 1.0f + 0.5f * (float)(level - 1));
                }
            } else if (this == LUCK) {
                entity.func_70097_a(DamageSource.field_76376_m, 0.5f + 0.25f * (float)(level - 1));
                if (entity.func_130014_f_().func_201674_k().nextInt(5) == 0) {
                    int exp = entity.func_130014_f_().func_201674_k().nextInt(4) + 1;
                    ExperienceOrbEntity orb = new ExperienceOrbEntity(entity.func_130014_f_(), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), exp);
                    entity.func_130014_f_().func_217376_c((Entity)orb);
                }
            } else if (this == DESTRUCTION) {
                EffectInstance eff = entity.func_70660_b(WardsRegistryManager.tickingExplosion);
                if (eff != null) {
                    int amp = eff.func_76458_c();
                    if (amp == 1) {
                        entity.func_130014_f_().func_230546_a_(null, DamageSource.field_76376_m, null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.5f + 0.4f * (float)level, false, Explosion.Mode.NONE);
                        entity.func_70097_a(DamageSource.field_76376_m, 1.0f + 0.75f * (float)(level - 1));
                        entity.func_195063_d(WardsRegistryManager.tickingExplosion);
                    } else {
                        entity.func_195064_c(new EffectInstance(WardsRegistryManager.tickingExplosion, 200, amp + 1));
                    }
                } else {
                    entity.func_195064_c(new EffectInstance(WardsRegistryManager.tickingExplosion, 200, 0));
                }
                entity.func_70097_a(DamageSource.field_76376_m, 0.5f + 0.5f * (float)(level - 1));
            } else if (this == SLAYER) {
                entity.func_70097_a(DamageSource.field_76376_m, 0.5f + 0.5f * (float)(level - 1));
                if (entity.func_70668_bt() == CreatureAttribute.field_223224_c_ || entity.func_70668_bt() == CreatureAttribute.field_223223_b_) {
                    entity.func_70097_a(DamageSource.field_76376_m, 1.0f + 0.5f * (float)(level - 1));
                }
            } else if (this == HASTE) {
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 25 * level, Math.min(level, 3)));
            } else if (this == KNOWLEDGE) {
                entity.func_195064_c(new EffectInstance(Effects.field_188423_x, 100, Math.min(level, 3)));
            } else if (this == CURSE) {
                entity.func_195064_c(new EffectInstance(Effects.field_82731_v, 60, Math.min(level, 3)));
            }
        }
    }

    public void empowerPlayer(WardTileEntity ward, PlayerEntity entity, int level) {
        if (!entity.func_130014_f_().field_72995_K) {
            if (this == COMBAT) {
                entity.func_195064_c(new EffectInstance(Effects.field_76420_g, this.getInterval(), Math.min(level, 3)));
            } else if (this == FORTITUDE) {
                entity.func_195064_c(new EffectInstance(Effects.field_76429_m, this.getInterval(), Math.min(level, 3)));
            } else if (this == FIRE) {
                entity.func_195064_c(new EffectInstance(Effects.field_76426_n, this.getInterval(), Math.min(level, 3)));
            } else if (this == WATER) {
                entity.func_195064_c(new EffectInstance(Effects.field_76427_o, this.getInterval(), Math.min(level, 3)));
            } else if (this == LUCK) {
                entity.func_195064_c(new EffectInstance(Effects.field_188425_z, this.getInterval(), Math.min(level, 3)));
            } else if (this == DESTRUCTION) {
                entity.func_195064_c(new EffectInstance(Effects.field_76444_x, this.getInterval(), Math.min(level, 3)));
            } else if (this == SLAYER) {
                entity.func_195064_c(new EffectInstance(WardsRegistryManager.slayer, this.getInterval(), Math.min(level, 3)));
            } else if (this == HASTE) {
                entity.func_195064_c(new EffectInstance(Effects.field_76424_c, this.getInterval(), Math.min(level, 3)));
            } else if (this == KNOWLEDGE) {
                entity.func_195064_c(new EffectInstance(Effects.field_76439_r, this.getInterval(), Math.min(level, 3)));
                entity.func_195064_c(new EffectInstance(Effects.field_76441_p, this.getInterval(), Math.min(level, 3)));
            } else if (this == CURSE) {
                entity.func_195064_c(new EffectInstance(Effects.field_76436_u, this.getInterval(), Math.min(level, 3)));
            }
        }
    }

    public static WardEnchantmentType fromEnchant(Enchantment enchant) {
        String registryStr = enchant.getRegistryName().toString();
        if (((List)WardsConfig.combatEnchantments.get()).contains(registryStr)) {
            return COMBAT;
        }
        if (((List)WardsConfig.fortitudeEnchantments.get()).contains(registryStr)) {
            return FORTITUDE;
        }
        if (((List)WardsConfig.fireEnchantments.get()).contains(registryStr)) {
            return FIRE;
        }
        if (((List)WardsConfig.waterEnchantments.get()).contains(registryStr)) {
            return WATER;
        }
        if (((List)WardsConfig.luckEnchantments.get()).contains(registryStr)) {
            return LUCK;
        }
        if (((List)WardsConfig.destructionEnchantments.get()).contains(registryStr)) {
            return DESTRUCTION;
        }
        if (((List)WardsConfig.slayerEnchantments.get()).contains(registryStr)) {
            return SLAYER;
        }
        if (((List)WardsConfig.hasteEnchantments.get()).contains(registryStr)) {
            return HASTE;
        }
        if (((List)WardsConfig.knowledgeEnchantments.get()).contains(registryStr)) {
            return KNOWLEDGE;
        }
        if (((List)WardsConfig.curseEnchantments.get()).contains(registryStr)) {
            return CURSE;
        }
        return COMBAT;
    }
}

