/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.warpedpots;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class WarpSavedData
extends WorldSavedData {
    private static final HashMap<UUID, WarpPos> WARP_MAP = new HashMap();

    public WarpSavedData() {
        super("warpedpots_WarpData");
    }

    public static WarpSavedData get(ServerWorld world) {
        return (WarpSavedData)world.func_217481_x().func_215752_a(WarpSavedData::new, "warpedpots_WarpData");
    }

    public void addWarp(LivingEntity entity) {
        WARP_MAP.put(entity.func_110124_au(), new WarpPos(new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()), entity.func_130014_f_().func_234923_W_().toString()));
        this.func_76185_a();
    }

    public BlockPos getWarp(LivingEntity entity) {
        if (WARP_MAP.containsKey(entity.func_110124_au())) {
            this.func_76185_a();
            if (entity.func_130014_f_().func_234923_W_().toString().equals(WARP_MAP.get(entity.func_110124_au()).getWorld())) {
                return WARP_MAP.remove(entity.func_110124_au()).pos;
            }
            WARP_MAP.remove(entity.func_110124_au());
        }
        return null;
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("warp_map", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compound = list.func_150305_b(i);
            WarpPos pos = new WarpPos(new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z")), compound.func_74779_i("world"));
            WARP_MAP.put(UUID.fromString(compound.func_74779_i("entity")), pos);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, WarpPos> i : WARP_MAP.entrySet()) {
            if (i.getKey() == null) continue;
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("entity", i.getKey().toString());
            nbt.func_74778_a("world", i.getValue().getWorld());
            nbt.func_74780_a("x", (double)i.getValue().getPos().func_177958_n());
            nbt.func_74780_a("y", (double)i.getValue().getPos().func_177956_o());
            nbt.func_74780_a("z", (double)i.getValue().getPos().func_177952_p());
            list.add((Object)nbt);
        }
        compound.func_218657_a("warp_map", (INBT)list);
        return compound;
    }

    private static class WarpPos {
        private final BlockPos pos;
        private final String world;

        public WarpPos(BlockPos loc, String dim) {
            this.pos = loc;
            this.world = dim;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public String getWorld() {
            return this.world;
        }
    }
}

