/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntityBase;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class WaystoneBlockBase
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public WaystoneBlockBase() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(5.0f, 2000.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighbor, IWorld world, BlockPos pos, BlockPos offset) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (this.isDoubleBlock(state)) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
            if ((facing.func_176740_k() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || neighbor.func_177230_c() == this && neighbor.func_177229_b(HALF) != half) && (half != DoubleBlockHalf.LOWER || facing != Direction.DOWN || state.func_196955_c((IWorldReader)world, pos))) {
                return state;
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (this.isDoubleBlock(state)) {
            super.func_180657_a(world, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
        } else {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
    }

    private boolean isDoubleBlock(BlockState state) {
        return state.func_235901_b_(HALF);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockState offsetState;
        boolean hasSilkTouch;
        TileEntity tileEntity = world.func_175625_s(pos);
        boolean isDoubleBlock = this.isDoubleBlock(state);
        DoubleBlockHalf half = isDoubleBlock ? (DoubleBlockHalf)state.func_177229_b(HALF) : null;
        BlockPos offset = half == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        TileEntity offsetTileEntity = isDoubleBlock ? world.func_175625_s(offset) : null;
        boolean bl = hasSilkTouch = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185306_r, (LivingEntity)player) > 0;
        if (hasSilkTouch) {
            if (tileEntity instanceof WaystoneTileEntityBase) {
                ((WaystoneTileEntityBase)tileEntity).setSilkTouched(true);
            }
            if (isDoubleBlock && offsetTileEntity instanceof WaystoneTileEntityBase) {
                ((WaystoneTileEntityBase)offsetTileEntity).setSilkTouched(true);
            }
        }
        if (isDoubleBlock && (offsetState = world.func_180495_p(offset)).func_177230_c() == this && offsetState.func_177229_b(HALF) != half) {
            world.func_225521_a_(half == DoubleBlockHalf.LOWER ? pos : offset, false, (Entity)player);
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                WaystoneBlockBase.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)tileEntity, (Entity)player, (ItemStack)player.func_184614_ca());
                WaystoneBlockBase.func_220054_a((BlockState)offsetState, (World)world, (BlockPos)offset, (TileEntity)offsetTileEntity, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        if (!PlayerWaystoneManager.mayBreakWaystone(player, world, pos)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (!this.isDoubleBlock(state)) {
            return true;
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return true;
        }
        BlockState below = world.func_180495_p(pos.func_177977_b());
        return below.func_177230_c() == this && below.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!PlayerWaystoneManager.mayPlaceWaystone(context.func_195999_j())) {
            return null;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        FluidState fluidState = world.func_204610_c(pos);
        if (pos.func_177956_o() < world.func_217301_I() - 1 && world.func_180495_p(pos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected void notifyObserversOfAction(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.func_177972_a(direction);
                BlockState neighbourState = world.func_180495_p(offset);
                Block neighbourBlock = neighbourState.func_177230_c();
                if (!(neighbourBlock instanceof ObserverBlock) || neighbourState.func_177229_b((Property)ObserverBlock.field_176387_N) != direction.func_176734_d() || world.func_205220_G_().func_205359_a(offset, (Object)neighbourBlock)) continue;
                world.func_205220_G_().func_205360_a(offset, (Object)neighbourBlock, 2);
            }
        }
    }

    @Nullable
    protected ActionResultType handleEditActions(World world, PlayerEntity player, WaystoneTileEntityBase tileEntity, IWaystone waystone) {
        if (player.func_225608_bj_()) {
            INamedContainerProvider settingsContainerProvider;
            WaystoneEditPermissions result = PlayerWaystoneManager.mayEditWaystone(player, world, waystone);
            if (result != WaystoneEditPermissions.ALLOW) {
                if (result.getLangKey() != null) {
                    TranslationTextComponent chatComponent = new TranslationTextComponent(result.getLangKey());
                    chatComponent.func_240699_a_(TextFormatting.RED);
                    player.func_146105_b((ITextComponent)chatComponent, true);
                }
                return ActionResultType.SUCCESS;
            }
            if (!world.field_72995_K && (settingsContainerProvider = tileEntity.getWaystoneSettingsContainerProvider()) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)settingsContainerProvider, buf -> Waystone.write(buf, tileEntity.getWaystone()));
            }
            return ActionResultType.SUCCESS;
        }
        return null;
    }

    @Nullable
    protected ActionResultType handleDebugActions(World world, PlayerEntity player, Hand hand, WaystoneTileEntityBase tileEntity) {
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() == Items.field_222068_kQ) {
                if (!world.field_72995_K) {
                    tileEntity.uninitializeWaystone();
                    player.func_146105_b((ITextComponent)new StringTextComponent("Waystone was successfully reset - it will re-initialize once it is next loaded."), false);
                }
                return ActionResultType.SUCCESS;
            }
            if (heldItem.func_77973_b() == Items.field_151055_y) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Waystone UUID: " + tileEntity.getWaystone().getWaystoneUid()), false);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return null;
    }

    protected void handleActivation(World world, BlockPos pos, PlayerEntity player, WaystoneTileEntityBase tileEntity, IWaystone waystone) {
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (!state.func_203425_a(newState.func_177230_c()) && (tileEntity = world.func_175625_s(pos)) instanceof WaystoneTileEntityBase && !((WaystoneTileEntityBase)tileEntity).isSilkTouched()) {
            IWaystone waystone = ((WaystoneTileEntityBase)tileEntity).getWaystone();
            WaystoneManager.get().removeWaystone(waystone);
            PlayerWaystoneManager.removeKnownWaystone(waystone);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        WaystoneProxy waystone;
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("UUID", 11) && (waystone = new WaystoneProxy(NBTUtil.func_186860_b((INBT)Objects.requireNonNull(tagCompound.func_74781_a("UUID"))))).isValid()) {
            this.addWaystoneNameToTooltip(tooltip, waystone);
        }
    }

    protected void addWaystoneNameToTooltip(List<ITextComponent> tooltip, WaystoneProxy waystone) {
        StringTextComponent component = new StringTextComponent(waystone.getName());
        component.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)component);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof WaystoneTileEntityBase) {
            WaystoneTileEntityBase waystoneTileEntity = (WaystoneTileEntityBase)tileEntity;
            ActionResultType result = this.handleDebugActions(world, player, hand, waystoneTileEntity);
            if (result != null) {
                return result;
            }
            IWaystone waystone = waystoneTileEntity.getWaystone();
            result = this.handleEditActions(world, player, waystoneTileEntity, waystone);
            if (result != null) {
                return result;
            }
            this.handleActivation(world, pos, player, waystoneTileEntity, waystone);
        }
        return ActionResultType.FAIL;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        BlockPos posAbove = pos.func_177984_a();
        boolean isDoubleBlock = this.isDoubleBlock(state);
        if (isDoubleBlock) {
            FluidState fluidStateAbove = world.func_204610_c(posAbove);
            world.func_175656_a(posAbove, (BlockState)((BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidStateAbove.func_206886_c() == Fluids.field_204546_a)));
        }
        if (tileEntity instanceof WaystoneTileEntityBase) {
            INamedContainerProvider settingsContainerProvider;
            WaystoneTileEntityBase waystoneTileEntity;
            ServerPlayerEntity player;
            WaystoneEditPermissions result;
            if (!world.field_72995_K) {
                TileEntity waystoneTileEntityAbove;
                CompoundNBT tag = stack.func_77978_p();
                WaystoneProxy existingWaystone = null;
                if (tag != null && tag.func_150297_b("UUID", 11)) {
                    existingWaystone = new WaystoneProxy(NBTUtil.func_186860_b((INBT)Objects.requireNonNull(tag.func_74781_a("UUID"))));
                }
                if (existingWaystone != null && existingWaystone.isValid() && existingWaystone.getBackingWaystone() instanceof Waystone) {
                    ((WaystoneTileEntityBase)tileEntity).initializeFromExisting((IServerWorld)world, (Waystone)existingWaystone.getBackingWaystone(), stack);
                } else {
                    ((WaystoneTileEntityBase)tileEntity).initializeWaystone((IServerWorld)world, placer, false);
                }
                if (isDoubleBlock && (waystoneTileEntityAbove = world.func_175625_s(posAbove)) instanceof WaystoneTileEntityBase) {
                    ((WaystoneTileEntityBase)waystoneTileEntityAbove).initializeFromBase((WaystoneTileEntityBase)tileEntity);
                }
            }
            if (placer instanceof PlayerEntity) {
                IWaystone waystone = ((WaystoneTileEntityBase)tileEntity).getWaystone();
                PlayerWaystoneManager.activateWaystone((PlayerEntity)placer, waystone);
                if (!world.field_72995_K) {
                    WaystoneSyncManager.sendActivatedWaystones((PlayerEntity)placer);
                }
            }
            if (!world.field_72995_K && placer instanceof ServerPlayerEntity && (result = PlayerWaystoneManager.mayEditWaystone((PlayerEntity)(player = (ServerPlayerEntity)placer), world, (waystoneTileEntity = (WaystoneTileEntityBase)tileEntity).getWaystone())) == WaystoneEditPermissions.ALLOW && (settingsContainerProvider = waystoneTileEntity.getWaystoneSettingsContainerProvider()) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)settingsContainerProvider, buf -> Waystone.write(buf, waystoneTileEntity.getWaystone()));
            }
        }
    }
}

