/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.client.render.PortstoneModel;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.tileentity.PortstoneTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.World;

public class PortstoneRenderer
extends TileEntityRenderer<PortstoneTileEntity> {
    private static final PortstoneModel model = new PortstoneModel();
    private static final RenderMaterial MATERIAL = new RenderMaterial(Atlases.field_228746_e_, new ResourceLocation("waystones", "entity/portstone"));
    private static ItemStack warpStoneItem;

    public PortstoneRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(PortstoneTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntity.func_145831_w();
        BlockState state = tileEntity.func_195044_w();
        if (world == null || state.func_177229_b((Property)PortstoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)PortstoneBlock.FACING);
        if (warpStoneItem == null) {
            warpStoneItem = new ItemStack((IItemProvider)ModItems.warpStone);
            warpStoneItem.func_77966_a(Enchantments.field_185307_s, 1);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(new Quaternion(0.0f, -facing.func_185119_l(), 0.0f, true));
        matrixStack.func_227863_a_(new Quaternion(-180.0f, 0.0f, 0.0f, true));
        matrixStack.func_227861_a_(0.0, -2.0, 0.0);
        float scale = 1.01f;
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227862_a_(scale, scale, scale);
        PortstoneModel model = new PortstoneModel();
        IVertexBuilder vertexBuilder = MATERIAL.func_229311_a_(buffer, RenderType::func_228638_b_);
        int light = (Boolean)WaystonesConfig.CLIENT.disableTextGlow.get() != false ? combinedLightIn : 0xF000F0;
        int overlay = (Boolean)WaystonesConfig.CLIENT.disableTextGlow.get() != false ? combinedOverlayIn : OverlayTexture.field_229196_a_;
        long gameTime = world.func_82737_E();
        float min = 0.7f;
        float color = (float)Math.max((double)min, (double)min + Math.abs(Math.sin((float)gameTime / 32.0f)) * (double)(1.0f - min));
        model.func_225598_a_(matrixStack, vertexBuilder, light, overlay, color, color, color, 1.0f);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.0, 0.5);
        matrixStack.func_227863_a_(new Quaternion(0.0f, -facing.func_185119_l(), 0.0f, true));
        matrixStack.func_227861_a_(0.0, 0.0, (double)0.15f);
        matrixStack.func_227863_a_(new Quaternion(-25.0f, 0.0f, 0.0f, true));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227861_a_(0.03125, 0.0, 0.0);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(warpStoneItem, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, buffer);
        matrixStack.func_227865_b_();
    }
}

