/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.client.render.SharestoneModel;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.tileentity.SharestoneTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.World;

public class SharestoneRenderer
extends TileEntityRenderer<SharestoneTileEntity> {
    private static final SharestoneModel model = new SharestoneModel();
    private static final RenderMaterial MATERIAL = new RenderMaterial(Atlases.field_228746_e_, new ResourceLocation("waystones", "entity/sharestone_color"));
    private static ItemStack warpStoneItem;

    public SharestoneRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(SharestoneTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntity.func_145831_w();
        BlockState state = tileEntity.func_195044_w();
        if (world == null || state.func_177229_b((Property)SharestoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        long gameTime = world.func_82737_E();
        DyeColor color = ((SharestoneBlock)state.func_177230_c()).getColor();
        if (color != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            matrixStack.func_227863_a_(new Quaternion(-180.0f, 0.0f, 0.0f, true));
            matrixStack.func_227861_a_(0.0, -2.0, 0.0);
            float scale = 1.01f;
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227862_a_(scale, scale, scale);
            IVertexBuilder vertexBuilder = MATERIAL.func_229311_a_(buffer, RenderType::func_228638_b_);
            int light = (Boolean)WaystonesConfig.CLIENT.disableTextGlow.get() != false ? combinedLightIn : 0xF000F0;
            int overlay = (Boolean)WaystonesConfig.CLIENT.disableTextGlow.get() != false ? combinedOverlayIn : OverlayTexture.field_229196_a_;
            float[] colors = color.func_193349_f();
            model.func_225598_a_(matrixStack, vertexBuilder, light, overlay, colors[0], colors[1], colors[2], 1.0f);
            matrixStack.func_227865_b_();
        }
        if (warpStoneItem == null) {
            warpStoneItem = new ItemStack((IItemProvider)ModItems.warpStone);
            warpStoneItem.func_77966_a(Enchantments.field_185307_s, 1);
        }
        float angle = (float)gameTime / 2.0f % 360.0f;
        float offsetY = (float)Math.sin((float)gameTime / 8.0f) * 0.025f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, (double)(1.0f + offsetY), 0.5);
        matrixStack.func_227863_a_(new Quaternion(0.0f, angle, 0.0f, true));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(warpStoneItem, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, buffer);
        matrixStack.func_227865_b_();
    }
}

