/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import mod.vemerion.wizardstaff.capability.Experience;
import mod.vemerion.wizardstaff.item.MagicArmorItem;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public abstract class Magic {
    public static final int HOUR = 72000;
    private float cost;
    private int duration;
    private Ingredient ingredient;

    public void init(float cost, int duration, Ingredient ingredient) {
        this.cost = cost;
        this.duration = duration;
        this.ingredient = ingredient;
    }

    protected float soundPitch(PlayerEntity player) {
        return 0.8f + player.func_70681_au().nextFloat() * 0.4f;
    }

    protected void playSoundServer(World world, PlayerEntity player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, SoundCategory.PLAYERS, volume, pitch);
    }

    protected final void cost(PlayerEntity player) {
        int whole = Experience.add(player, (double)this.cost * this.discount(player));
        double debt = this.debt(player, whole);
        player.func_195068_e(-whole);
        if (debt > 0.0) {
            player.func_70097_a(DamageSource.field_76376_m, (float)debt);
        }
    }

    private double discount(PlayerEntity player) {
        return 1.0 - 0.1 * (double)MagicArmorItem.countMagicArmorPieces(player);
    }

    private double debt(PlayerEntity player, double amount) {
        int trueLevel = player.field_71068_ca;
        amount -= (double)(player.field_71106_cc * (float)player.func_71050_bK());
        while (--player.field_71068_ca >= 0 && amount > 0.0) {
            amount -= (double)player.func_71050_bK();
        }
        player.field_71068_ca = trueLevel;
        return amount;
    }

    public final int getUseDuration(ItemStack staff) {
        return this.duration;
    }

    public final boolean isMagicItem(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public abstract WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer();

    public abstract WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer();

    public abstract UseAction getUseAction(ItemStack var1);

    public void magicStart(World world, PlayerEntity player, ItemStack staff) {
    }

    public void magicTick(World world, PlayerEntity player, ItemStack staff, int count) {
    }

    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        return staff;
    }

    public void magicCancel(World world, PlayerEntity player, ItemStack staff, int timeLeft) {
    }
}

