/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.NoMagic;
import mod.vemerion.wizardstaff.Magic.fashionupdate.FashionMagic;
import mod.vemerion.wizardstaff.Magic.netherupdate.GhastTearMagic;
import mod.vemerion.wizardstaff.Magic.netherupdate.GlowstoneDustMagic;
import mod.vemerion.wizardstaff.Magic.netherupdate.NetherBrickMagic;
import mod.vemerion.wizardstaff.Magic.netherupdate.NetherrackMagic;
import mod.vemerion.wizardstaff.Magic.netherupdate.ObsidianMagic;
import mod.vemerion.wizardstaff.Magic.netherupdate.SoulSandMagic;
import mod.vemerion.wizardstaff.Magic.netherupdate.WitherSkullMagic;
import mod.vemerion.wizardstaff.Magic.original.BlazePowderMagic;
import mod.vemerion.wizardstaff.Magic.original.CarvedPumpkinMagic;
import mod.vemerion.wizardstaff.Magic.original.ClockMagic;
import mod.vemerion.wizardstaff.Magic.original.EggMagic;
import mod.vemerion.wizardstaff.Magic.original.ElytraMagic;
import mod.vemerion.wizardstaff.Magic.original.GoldMagic;
import mod.vemerion.wizardstaff.Magic.original.JukeboxMagic;
import mod.vemerion.wizardstaff.Magic.original.WizardStaffMagic;
import mod.vemerion.wizardstaff.Magic.original.WritableBookMagic;
import mod.vemerion.wizardstaff.Magic.suggestions.BlueDyeMagic;
import mod.vemerion.wizardstaff.Magic.suggestions.BricksMagic;
import mod.vemerion.wizardstaff.Magic.suggestions.FeatherMagic;
import mod.vemerion.wizardstaff.Magic.suggestions.GrapplingHookMagic;
import mod.vemerion.wizardstaff.Magic.suggestions.MushroomCloudMagic;
import mod.vemerion.wizardstaff.Magic.suggestions.ShulkerBulletMagic;
import mod.vemerion.wizardstaff.Magic.suggestions.WaterBucketMagic;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.network.Network;
import mod.vemerion.wizardstaff.network.UpdateMagicsMessage;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.PacketDistributor;

public class Magics
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FOLDER_NAME = "wizard-staff-magics";
    private static Magics instance;
    private Map<String, Supplier<Magic>> magicNames;
    private Map<ResourceLocation, Magic> magics;
    private Map<ResourceLocation, MagicParams> magicParams;
    private Map<Item, ResourceLocation> cache;
    private final NoMagic NO_MAGIC = new NoMagic();

    private Magics() {
        super(GSON, FOLDER_NAME);
        this.magicNames = new HashMap<String, Supplier<Magic>>();
        this.magics = new HashMap<ResourceLocation, Magic>();
        this.cache = new HashMap<Item, ResourceLocation>();
        this.magicParams = new HashMap<ResourceLocation, MagicParams>();
        this.initMagicNames();
    }

    public Magic get(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (this.cache.containsKey(item) && this.magics.get(this.cache.get(item)).isMagicItem(stack)) {
            return this.magics.get(this.cache.get(item));
        }
        for (Map.Entry<ResourceLocation, Magic> entry : this.magics.entrySet()) {
            if (!entry.getValue().isMagicItem(stack)) continue;
            Magic magic = entry.getValue();
            this.cache.put(stack.func_77973_b(), entry.getKey());
            return magic;
        }
        return this.NO_MAGIC;
    }

    private void initMagicNames() {
        this.magicNames.put("blaze_powder_magic", () -> new BlazePowderMagic());
        this.magicNames.put("carved_pumpkin_magic", () -> new CarvedPumpkinMagic());
        this.magicNames.put("clock_magic", () -> new ClockMagic());
        this.magicNames.put("egg_magic", () -> new EggMagic());
        this.magicNames.put("elytra_magic", () -> new ElytraMagic());
        this.magicNames.put("gold_magic", () -> new GoldMagic());
        this.magicNames.put("jukebox_magic", () -> new JukeboxMagic());
        this.magicNames.put("wizard_staff_magic", () -> new WizardStaffMagic());
        this.magicNames.put("writable_book_magic", () -> new WritableBookMagic());
        this.magicNames.put("obsidian_magic", () -> new ObsidianMagic());
        this.magicNames.put("glowstone_dust_magic", () -> new GlowstoneDustMagic());
        this.magicNames.put("netherrack_magic", () -> new NetherrackMagic());
        this.magicNames.put("wither_skull_magic", () -> new WitherSkullMagic());
        this.magicNames.put("ghast_tear_magic", () -> new GhastTearMagic());
        this.magicNames.put("nether_brick_magic", () -> new NetherBrickMagic());
        this.magicNames.put("soul_sand_magic", () -> new SoulSandMagic());
        this.magicNames.put("wizard_boots_fashion_magic", () -> new FashionMagic((Item)Main.WIZARD_BOOTS_ITEM));
        this.magicNames.put("wizard_chestplate_fashion_magic", () -> new FashionMagic((Item)Main.WIZARD_CHESTPLATE_ITEM));
        this.magicNames.put("wizard_helmet_fashion_magic", () -> new FashionMagic((Item)Main.WIZARD_HAT_ITEM));
        this.magicNames.put("wizard_leggings_fashion_magic", () -> new FashionMagic((Item)Main.WIZARD_LEGGINGS_ITEM));
        this.magicNames.put("druid_boots_fashion_magic", () -> new FashionMagic((Item)Main.DRUID_BOOTS_ITEM));
        this.magicNames.put("druid_chestplate_fashion_magic", () -> new FashionMagic((Item)Main.DRUID_CHESTPLATE_ITEM));
        this.magicNames.put("druid_helmet_fashion_magic", () -> new FashionMagic((Item)Main.DRUID_HELMET_ITEM));
        this.magicNames.put("druid_leggings_fashion_magic", () -> new FashionMagic((Item)Main.DRUID_LEGGINGS_ITEM));
        this.magicNames.put("warlock_boots_fashion_magic", () -> new FashionMagic((Item)Main.WARLOCK_BOOTS_ITEM));
        this.magicNames.put("warlock_chestplate_fashion_magic", () -> new FashionMagic((Item)Main.WARLOCK_CHESTPLATE_ITEM));
        this.magicNames.put("warlock_helmet_fashion_magic", () -> new FashionMagic((Item)Main.WARLOCK_HELMET_ITEM));
        this.magicNames.put("warlock_leggings_fashion_magic", () -> new FashionMagic((Item)Main.WARLOCK_LEGGINGS_ITEM));
        this.magicNames.put("blue_dye_magic", () -> new BlueDyeMagic());
        this.magicNames.put("bricks_magic", () -> new BricksMagic());
        this.magicNames.put("grappling_hook_magic", () -> new GrapplingHookMagic());
        this.magicNames.put("feather_magic", () -> new FeatherMagic());
        this.magicNames.put("mushroom_cloud_magic", () -> new MushroomCloudMagic());
        this.magicNames.put("shulker_bullet_magic", () -> new ShulkerBulletMagic());
        this.magicNames.put("water_bucket_magic", () -> new WaterBucketMagic());
        this.magicNames.put("no_magic", () -> this.NO_MAGIC);
    }

    public static Magics getInstance() {
        return instance;
    }

    public static void init() {
        instance = new Magics();
    }

    protected void apply(Map<ResourceLocation, JsonObject> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap<ResourceLocation, MagicParams> params = new HashMap<ResourceLocation, MagicParams>();
        for (Map.Entry<ResourceLocation, JsonObject> entry : objectIn.entrySet()) {
            JsonObject json = entry.getValue();
            float cost = JSONUtils.func_151217_k((JsonObject)json, (String)"cost");
            if (cost < 0.0f) {
                throw new JsonSyntaxException("The cost of a magic can not be negative");
            }
            int duration = JSONUtils.func_151203_m((JsonObject)json, (String)"duration");
            String magic = JSONUtils.func_151200_h((JsonObject)json, (String)"magic");
            if (!this.magicNames.containsKey(magic)) {
                throw new JsonSyntaxException("The magic " + magic + " does not exist");
            }
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
            params.put(entry.getKey(), new MagicParams(cost, duration, magic, ingredient));
        }
        this.magicParams.putAll(params);
        this.addMagics(params);
        this.sendMagicMessage(params);
    }

    private void sendMagicMessage(Map<ResourceLocation, MagicParams> params) {
        Network.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UpdateMagicsMessage(params));
    }

    public void sendAllMagicMessage(ServerPlayerEntity reciever) {
        Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> reciever), (Object)new UpdateMagicsMessage(this.magicParams));
    }

    public void addMagics(Map<ResourceLocation, MagicParams> params) {
        this.cache = new HashMap<Item, ResourceLocation>();
        for (Map.Entry<ResourceLocation, MagicParams> entry : params.entrySet()) {
            this.magics.put(entry.getKey(), entry.getValue().createMagic());
        }
    }

    public static class MagicParams {
        private float cost;
        private int duration;
        private String magicKey;
        private Ingredient ingredient;

        public MagicParams(float cost, int duration, String magicKey, Ingredient ingredient) {
            this.cost = cost;
            this.duration = duration;
            this.magicKey = magicKey;
            this.ingredient = ingredient;
        }

        public Magic createMagic() {
            Magic magic = (Magic)((Supplier)Magics.getInstance().magicNames.get(this.magicKey)).get();
            magic.init(this.cost, this.duration < 0 ? 72000 : this.duration, this.ingredient);
            return magic;
        }

        public static MagicParams decode(PacketBuffer buffer) {
            return new MagicParams(buffer.readFloat(), buffer.readInt(), buffer.func_150789_c(100), Ingredient.func_199566_b((PacketBuffer)buffer));
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeFloat(this.cost);
            buffer.writeInt(this.duration);
            buffer.func_180714_a(this.magicKey);
            this.ingredient.func_199564_a(buffer);
        }
    }
}

