/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.entity;

import java.util.UUID;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.particle.MagicDustParticleData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MushroomCloudEntity
extends Entity {
    private static final int DURATION = 200;
    private UUID shooter;

    public MushroomCloudEntity(EntityType<? extends MushroomCloudEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
    }

    public MushroomCloudEntity(World worldIn, PlayerEntity shooter) {
        this(Main.MUSHROOM_CLOUD_ENTITY, worldIn);
        this.shooter = shooter.func_110124_au();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.damageEntities();
            if (this.field_70173_aa > 200) {
                this.func_70106_y();
            }
        } else {
            this.createParticles();
        }
    }

    private void createParticles() {
        for (int i = 0; i < 10; ++i) {
            Vec3d pos = this.randomParticlePos();
            this.field_70170_p.func_195594_a((IParticleData)new MagicDustParticleData(this.field_70146_Z.nextFloat() * 0.2f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f, 1.0f), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.5, 0.0);
        }
    }

    private Vec3d randomParticlePos() {
        AxisAlignedBB box = this.func_174813_aQ();
        double x = this.field_70146_Z.nextDouble() * (box.field_72336_d - box.field_72340_a) + box.field_72340_a;
        double y = this.field_70146_Z.nextDouble() * (box.field_72337_e - box.field_72338_b) + box.field_72338_b;
        double z = this.field_70146_Z.nextDouble() * (box.field_72334_f - box.field_72339_c) + box.field_72339_c;
        return new Vec3d(x, y, z);
    }

    private void damageEntities() {
        PlayerEntity caster = this.getShooter();
        for (LivingEntity e2 : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ(), e -> e != caster && e.func_70089_S())) {
            if (caster != null) {
                e2.func_70097_a(DamageSource.func_76365_a((PlayerEntity)caster), 2.0f);
            } else {
                e2.func_70097_a(DamageSource.field_76376_m, 2.0f);
            }
            if (!(e2.func_110143_aJ() <= 0.0f)) continue;
            this.spawnMushrooms(e2.func_174824_e(1.0f));
        }
    }

    private void spawnMushrooms(Vec3d pos) {
        for (int i = 0; i < this.field_70146_Z.nextInt(5) + 3; ++i) {
            Vec3d spawnPos = pos.func_72441_c(this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5);
            ItemEntity mushroom = new ItemEntity(this.field_70170_p, spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, new ItemStack((IItemProvider)(this.field_70146_Z.nextBoolean() ? Items.field_221694_bi : Items.field_221692_bh)));
            this.field_70170_p.func_217376_c((Entity)mushroom);
        }
    }

    private PlayerEntity getShooter() {
        if (this.shooter == null) {
            return null;
        }
        return this.field_70170_p.func_217371_b(this.shooter);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("shooter")) {
            this.shooter = compound.func_186857_a("shooter");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.shooter != null) {
            compound.func_186854_a("shooter", this.shooter);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

