/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.entity;

import java.util.Random;
import java.util.UUID;
import mod.vemerion.wizardstaff.Main;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class PumpkinMagicEntity
extends Entity {
    private UUID shooter;

    public PumpkinMagicEntity(EntityType<? extends PumpkinMagicEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
    }

    public PumpkinMagicEntity(EntityType<? extends PumpkinMagicEntity> entityTypeIn, World worldIn, PlayerEntity shooter) {
        super(entityTypeIn, worldIn);
        this.shooter = shooter.func_110124_au();
        this.func_189654_d(true);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213315_a(MoverType.SELF, Vec3d.func_189984_a((Vec2f)this.func_189653_aC()).func_186678_a(0.1));
        if (!this.field_70170_p.field_72995_K) {
            this.spawnParticles();
            this.collision();
            if (this.field_70173_aa > 120) {
                this.func_70106_y();
            }
        }
    }

    private PlayerEntity getShooter() {
        if (this.shooter == null) {
            return null;
        }
        return this.field_70170_p.func_217371_b(this.shooter);
    }

    private void collision() {
        Vec3d sideways = Vec3d.func_189986_a((float)0.0f, (float)(this.field_70177_z + 90.0f));
        Vec3d pos = this.func_213303_ch().func_72441_c(sideways.field_72450_a * 3.0, 0.0, sideways.field_72449_c * 3.0);
        PlayerEntity shooter = this.getShooter();
        DamageSource source = shooter == null ? DamageSource.field_76376_m : DamageSource.func_76365_a((PlayerEntity)shooter);
        for (int i = 0; i < 6; ++i) {
            for (Entity e2 : this.field_70170_p.func_175674_a((Entity)shooter, new AxisAlignedBB(pos, pos).func_72314_b(1.0, 2.0, 1.0), e -> e instanceof LivingEntity)) {
                e2.func_70097_a(source, 1.0f);
                LivingEntity living = (LivingEntity)e2;
                living.func_195064_c(new EffectInstance(Effects.field_76437_t, 10, 1));
            }
            pos = pos.func_72441_c(-sideways.field_72450_a, 0.0, -sideways.field_72449_c);
        }
    }

    private void spawnParticles() {
        ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
        Vec3d sideways = Vec3d.func_189986_a((float)0.0f, (float)(this.field_70177_z + 90.0f));
        Random random = new Random(0L);
        double radius = 1.7;
        for (int i = -1; i < 2; i += 2) {
            Vec3d pos = this.func_213303_ch().func_72441_c(sideways.field_72450_a * 2.0 * (double)i, 2.0, sideways.field_72449_c * 2.0 * (double)i);
            for (int j = 0; j < 50; ++j) {
                Vec3d offset = Vec3d.func_189986_a((float)(random.nextFloat() * 360.0f), (float)(this.field_70177_z + 90.0f)).func_186678_a((radius + random.nextDouble() * 0.4 - 0.2) * random.nextDouble());
                serverWorld.func_195598_a((IParticleData)Main.MAGIC_SMOKE_PARTICLE_TYPE, pos.field_72450_a + offset.field_72450_a, pos.field_72448_b + offset.field_72448_b, pos.field_72449_c + offset.field_72449_c, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        Vec3d pos = this.func_213303_ch().func_72441_c(sideways.field_72450_a * 3.0, -1.0, sideways.field_72449_c * 3.0);
        for (int i = 0; i < 50; ++i) {
            serverWorld.func_195598_a((IParticleData)Main.MAGIC_SMOKE_PARTICLE_TYPE, pos.field_72450_a, pos.field_72448_b + random.nextDouble() - 0.5, pos.field_72449_c, 1, 0.0, 0.0, 0.0, 0.0);
            pos = pos.func_72441_c(-sideways.field_72450_a * 0.12, 0.0, -sideways.field_72449_c * 0.12);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("shooter")) {
            this.shooter = compound.func_186857_a("shooter");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.shooter != null) {
            compound.func_186854_a("shooter", this.shooter);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

