/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.item;

import java.util.List;
import mod.vemerion.wizardstaff.model.MagicArmorModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MagicArmorItem
extends DyeableArmorItem {
    protected static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    protected static final int[] PROTECTION_ARRAY = new int[]{1, 2, 3, 1};
    @OnlyIn(value=Dist.CLIENT)
    protected MagicArmorModel<?> model;

    public MagicArmorItem(IArmorMaterial material, EquipmentSlotType slot) {
        super(material, slot, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78027_g));
    }

    public int func_200886_f(ItemStack stack) {
        return this.func_200883_f_(stack) ? super.func_200886_f(stack) : this.getDefaultColor();
    }

    protected abstract int getDefaultColor();

    protected abstract String getMagicArmorName();

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if ("overlay".equals(type)) {
            return "wizard-staff:textures/armor/" + this.getMagicArmorName() + "_overlay.png";
        }
        return "wizard-staff:textures/armor/" + this.getMagicArmorName() + ".png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("item.wizard-staff." + this.getMagicArmorName() + ".description", new Object[0]).func_211708_a(TextFormatting.BLUE));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        MagicArmorModel<?> model = this.getModel();
        model.setVisibility(armorSlot);
        model.field_217113_d = _default.field_217113_d;
        model.field_228270_o_ = _default.field_228270_o_;
        model.field_217114_e = _default.field_217114_e;
        model.field_187076_m = _default.field_187076_m;
        model.field_187075_l = _default.field_187075_l;
        return (A)((Object)model);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract MagicArmorModel<?> getModel();

    public static int countMagicArmorPieces(PlayerEntity player) {
        int count = 0;
        for (ItemStack armor : player.func_184193_aE()) {
            if (!(armor.func_77973_b() instanceof MagicArmorItem)) continue;
            ++count;
        }
        return count;
    }

    protected static abstract class MagicArmorMaterial
    implements IArmorMaterial {
        protected MagicArmorMaterial() {
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            return MAX_DAMAGE_ARRAY[slotIn.func_188454_b()] * 5;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return PROTECTION_ARRAY[slotIn.func_188454_b()];
        }

        public int func_200900_a() {
            return 20;
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187728_s;
        }

        public float func_200901_e() {
            return 0.0f;
        }
    }
}

