/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.vemerion.wizardstaff.Magic.Magics;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateMagicsMessage {
    private Map<ResourceLocation, Magics.MagicParams> magicParams;

    public UpdateMagicsMessage(Map<ResourceLocation, Magics.MagicParams> magicParams) {
        this.magicParams = magicParams;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.magicParams.size());
        for (Map.Entry<ResourceLocation, Magics.MagicParams> entry : this.magicParams.entrySet()) {
            buffer.func_192572_a(entry.getKey());
            entry.getValue().encode(buffer);
        }
    }

    public static UpdateMagicsMessage decode(PacketBuffer buffer) {
        HashMap<ResourceLocation, Magics.MagicParams> magicParams = new HashMap<ResourceLocation, Magics.MagicParams>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.func_192575_l();
            magicParams.put(key, Magics.MagicParams.decode(buffer));
        }
        return new UpdateMagicsMessage(magicParams);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> UpdateMagics.update(this.magicParams)));
    }

    private static class UpdateMagics {
        private UpdateMagics() {
        }

        private static Runnable update(final Map<ResourceLocation, Magics.MagicParams> magicParams) {
            return new Runnable(){

                @Override
                public void run() {
                    if (Magics.getInstance() != null) {
                        Magics.getInstance().addMagics(magicParams);
                    }
                }
            };
        }
    }
}

