/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.vemerion.wizardstaff.entity.GrapplingHookEntity;
import mod.vemerion.wizardstaff.model.GrapplingHookModel;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class GrapplingHookRenderer
extends EntityRenderer<GrapplingHookEntity> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("wizard-staff", "textures/entity/grappling_hook.png");
    private final GrapplingHookModel model = new GrapplingHookModel();

    public GrapplingHookRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(GrapplingHookEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.model.setRotationAngles(entityIn, 0.0f, 0.0f, (float)entityIn.field_70173_aa + partialTicks, (float)Math.toRadians(180.0f - entityIn.func_195046_g(partialTicks)), (float)Math.toRadians(-entityIn.func_195050_f(partialTicks)));
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.model.func_228282_a_(this.getEntityTexture(entityIn)));
        this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227860_a_();
        if (entityIn.getShooter() != null) {
            Vec3d shooterPos;
            float handOffset;
            PlayerEntity shooter = entityIn.getShooter();
            float f = handOffset = shooter.func_184591_cq() == HandSide.RIGHT ? 1.0f : -1.0f;
            if (!(shooter.func_184614_ca().func_77973_b() instanceof WizardStaffItem)) {
                handOffset *= -1.0f;
            }
            if ((this.field_76990_c.field_78733_k == null || this.field_76990_c.field_78733_k.field_74320_O <= 0) && shooter == Minecraft.func_71410_x().field_71439_g) {
                double fov = this.field_76990_c.field_78733_k.field_74334_X / 100.0;
                Vec3d fovOffset = new Vec3d(-0.1 * fov * (double)handOffset, 0.03 * fov, 0.3);
                fovOffset = fovOffset.func_178789_a((float)(-Math.toRadians(shooter.func_195050_f(partialTicks))));
                fovOffset = fovOffset.func_178785_b((float)(-Math.toRadians(shooter.func_195046_g(partialTicks))));
                shooterPos = shooter.func_174824_e(partialTicks).func_178788_d(entityIn.func_213303_ch()).func_178787_e(fovOffset);
            } else {
                float renderYawOffset = MathHelper.func_219799_g((float)partialTicks, (float)shooter.field_70760_ar, (float)shooter.field_70761_aq) * ((float)Math.PI / 180);
                float xOffset = MathHelper.func_76126_a((float)renderYawOffset);
                float yOffset = MathHelper.func_76134_b((float)renderYawOffset);
                Vec3d offset = new Vec3d((double)(-xOffset) * 0.8, 0.2, (double)yOffset * 0.8);
                shooterPos = shooter.func_174824_e(partialTicks).func_178788_d(entityIn.func_213303_ch()).func_178787_e(offset);
            }
            IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228659_m_());
            Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
            builder.func_227888_a_(matrix, 0.0f, 0.1f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            builder.func_227888_a_(matrix, (float)shooterPos.field_72450_a, (float)shooterPos.field_72448_b, (float)shooterPos.field_72449_c).func_225586_a_(0, 0, 0, 255).func_181675_d();
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected boolean canRenderName(GrapplingHookEntity entity) {
        return false;
    }

    public ResourceLocation getEntityTexture(GrapplingHookEntity entity) {
        return TEXTURES;
    }
}

