/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class WizardStaffLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public WizardStaffLayer(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack activeItem = player.func_184607_cu();
        Item item = activeItem.func_77973_b();
        if (activeItem.func_190926_b() || !(item instanceof WizardStaffItem)) {
            return;
        }
        WizardStaffTileEntityRenderer renderer = (WizardStaffTileEntityRenderer)item.getItemStackTileEntityRenderer();
        ItemStack magic = ((WizardStaffItem)item).getMagic(activeItem);
        int maxDuration = activeItem.func_77988_m();
        float duration = (float)maxDuration - ((float)player.func_184605_cv() - partialTicks + 1.0f);
        HandSide side = player.func_184600_cs() == Hand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        Magics.getInstance().get(magic).thirdPersonRenderer().render(renderer, duration, maxDuration, activeItem, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, partialTicks, side);
    }

    public static void helicopter(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        matrix.func_227860_a_();
        float offset = hand == HandSide.RIGHT ? 1.0f : -1.0f;
        matrix.func_227861_a_(-0.4 * (double)offset, -0.5, 0.0);
        matrix.func_227863_a_(new Quaternion(90.0f, 0.0f, duration / 5.0f * 360.0f, true));
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void buildup(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        float sideOffset = hand == HandSide.RIGHT ? 1.0f : -1.0f;
        float progress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3d offset = new Vec3d((random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress);
        matrix.func_227860_a_();
        matrix.func_227861_a_(-0.1 * (double)sideOffset + MathHelper.func_151238_b((double)0.0, (double)offset.func_82615_a(), (double)partialTicks), 0.6 + MathHelper.func_151238_b((double)0.0, (double)offset.func_82617_b(), (double)partialTicks), -0.45 + MathHelper.func_151238_b((double)0.0, (double)offset.func_82616_c(), (double)partialTicks));
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void spinMagic(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        matrix.func_227860_a_();
        float progress = duration / 5.0f;
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrix.func_227861_a_(hand == HandSide.RIGHT ? 0.38 : -0.38, -0.6, 0.0);
        matrix.func_227863_a_(new Quaternion(-75.0f, 0.0f, 0.0f, true));
        renderer.renderOnlyStaffNoPop(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227863_a_(new Quaternion(0.0f, progress * 360.0f, 0.0f, true));
        renderer.renderOnlyMagic(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
        matrix.func_227865_b_();
    }

    public static void buildupMagic(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        float sideOffset = hand == HandSide.RIGHT ? 1.0f : -1.0f;
        float progress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3d offset = new Vec3d((random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress);
        matrix.func_227860_a_();
        matrix.func_227861_a_(-0.14 * (double)sideOffset, 0.6, -0.45);
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        renderer.renderOnlyStaffNoPop(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227861_a_(MathHelper.func_151238_b((double)0.0, (double)offset.func_82615_a(), (double)partialTicks), MathHelper.func_151238_b((double)0.0, (double)offset.func_82617_b(), (double)partialTicks), MathHelper.func_151238_b((double)0.0, (double)offset.func_82616_c(), (double)partialTicks));
        renderer.renderOnlyMagic(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
        matrix.func_227865_b_();
    }

    public static void swinging(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        matrix.func_227860_a_();
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrix.func_227863_a_(new Quaternion(MathHelper.func_76126_a((float)(duration / 20.0f * (float)Math.PI * 2.0f)) * 15.0f - 65.0f, 0.0f, 0.0f, true));
        matrix.func_227861_a_(hand == HandSide.RIGHT ? 0.4 : -0.4, -0.3, -0.65);
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void forwardShake(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        float offset = hand == HandSide.RIGHT ? 1.0f : -1.0f;
        Random random = new Random((int)duration % 5 + 5);
        Vec3d shake = new Vec3d(random.nextDouble() * 0.2 - 0.1, random.nextDouble() * 0.2 - 0.1, random.nextDouble() * 0.2 - 0.1);
        matrix.func_227860_a_();
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrix.func_227861_a_(MathHelper.func_151238_b((double)0.0, (double)shake.func_82615_a(), (double)partialTicks), MathHelper.func_151238_b((double)0.0, (double)shake.func_82617_b(), (double)partialTicks), MathHelper.func_151238_b((double)0.0, (double)shake.func_82616_c(), (double)partialTicks));
        matrix.func_227861_a_((double)offset * 0.25, -0.7, -0.3);
        matrix.func_227863_a_(new Quaternion(-30.0f, 10.0f * offset, 20.0f * offset, true));
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void noRender(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
    }

    @FunctionalInterface
    public static interface RenderThirdPersonMagic {
        public void render(WizardStaffTileEntityRenderer var1, float var2, int var3, ItemStack var4, MatrixStack var5, IRenderTypeBuffer var6, int var7, int var8, float var9, HandSide var10);
    }
}

