/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import mod.vemerion.wizardstaff.model.WizardStaffModel;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.LazyOptional;

public class WizardStaffTileEntityRenderer
extends ItemStackTileEntityRenderer {
    private final WizardStaffModel STAFF = new WizardStaffModel();

    public void func_228364_a_(ItemStack itemStackIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!this.shouldRender(itemStackIn)) {
            return;
        }
        this.renderOnlyStaffNoPop(itemStackIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderOnlyMagic(itemStackIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
    }

    protected WizardStaffModel getModel() {
        return this.STAFF;
    }

    private boolean shouldRender(ItemStack staff) {
        LazyOptional<WizardStaffItemHandler> optHandler = WizardStaffItemHandler.getOptional(staff);
        return optHandler.isPresent() && ((WizardStaffItemHandler)((Object)optHandler.orElse(null))).isVisible();
    }

    protected void renderOnlyStaffNoPop(ItemStack itemStackIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!this.shouldRender(itemStackIn)) {
            return;
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(1.0f, -1.0f, -1.0f);
        matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)this.getModel().func_228282_a_(WizardStaffModel.TEXTURE_LOCATION), (boolean)false, (boolean)itemStackIn.func_77962_s());
        this.getModel().func_225598_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderOnlyMagic(ItemStack itemStackIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!this.shouldRender(itemStackIn)) {
            return;
        }
        ItemStack magic = ((WizardStaffItem)itemStackIn.func_77973_b()).getMagic(itemStackIn);
        float ageInTicks = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + Minecraft.func_71410_x().func_184121_ak();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, -3.1, 0.0);
        matrixStackIn.func_227863_a_(new Quaternion(180.0f, ageInTicks, 0.0f, true));
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        matrixStackIn.func_227862_a_(0.9f, 0.9f, 0.9f);
        itemRenderer.func_229110_a_(magic, ItemCameraTransforms.TransformType.GUI, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
    }

    public static void buildup(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide side) {
        float progress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3d offset = new Vec3d((random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress);
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0 + MathHelper.func_151238_b((double)0.0, (double)offset.func_82615_a(), (double)partialTicks), -1.4 + MathHelper.func_151238_b((double)0.0, (double)offset.func_82617_b(), (double)partialTicks), -1.5 + MathHelper.func_151238_b((double)0.0, (double)offset.func_82616_c(), (double)partialTicks));
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void helicopter(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        matrix.func_227860_a_();
        matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, duration / 5.0f * 360.0f, true));
        matrix.func_227861_a_(0.0, -0.5, -1.5);
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void forward(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        float offset = hand == HandSide.RIGHT ? 1.0f : -1.0f;
        float max = maxDuration > 20 ? 5.0f : (float)(maxDuration / 4);
        float progress = MathHelper.func_76131_a((float)(duration / max), (float)0.0f, (float)1.0f);
        matrix.func_227860_a_();
        matrix.func_227863_a_(new Quaternion((float)MathHelper.func_151238_b((double)0.0, (double)-45.0, (double)progress), 0.0f, (float)MathHelper.func_151238_b((double)0.0, (double)(35.0f * offset), (double)progress), true));
        matrix.func_227861_a_((double)offset, -0.5 - (double)(progress / 5.0f), -1.2);
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void spinMagic(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        matrix.func_227860_a_();
        float progress = duration / 5.0f;
        matrix.func_227861_a_(hand == HandSide.RIGHT ? 1.0 : -1.0, -1.0, -1.2);
        renderer.renderOnlyStaffNoPop(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227863_a_(new Quaternion(0.0f, progress * 360.0f, 0.0f, true));
        renderer.renderOnlyMagic(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
        matrix.func_227865_b_();
    }

    public static void buildupMagic(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        matrix.func_227860_a_();
        float progress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3d offset = new Vec3d((random.nextDouble() * 0.3 - 0.15) * (double)progress, (random.nextDouble() * 0.3 - 0.15) * (double)progress, (random.nextDouble() * 0.3 - 0.15) * (double)progress);
        matrix.func_227860_a_();
        matrix.func_227861_a_(hand == HandSide.RIGHT ? 1.0 : -1.0, -1.0, -1.2);
        renderer.renderOnlyStaffNoPop(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227861_a_(0.0 + MathHelper.func_151238_b((double)0.0, (double)offset.func_82615_a(), (double)partialTicks), MathHelper.func_151238_b((double)0.0, (double)offset.func_82617_b(), (double)partialTicks), MathHelper.func_151238_b((double)0.0, (double)offset.func_82616_c(), (double)partialTicks));
        renderer.renderOnlyMagic(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
        matrix.func_227865_b_();
    }

    public static void swinging(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        matrix.func_227860_a_();
        matrix.func_227863_a_(new Quaternion(MathHelper.func_76126_a((float)(duration / 20.0f * (float)Math.PI * 2.0f)) * 30.0f, 0.0f, 0.0f, true));
        matrix.func_227861_a_(hand == HandSide.RIGHT ? 1.0 : -1.0, -1.0, -1.2);
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void forwardBuildup(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        float handOffset = hand == HandSide.RIGHT ? 1.0f : -1.0f;
        float max = maxDuration > 20 ? 5.0f : (float)(maxDuration / 4);
        float progress = MathHelper.func_76131_a((float)(duration / max), (float)0.0f, (float)1.0f);
        float buildupProgress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3d offset = new Vec3d((random.nextDouble() * 0.5 - 0.25) * (double)buildupProgress, (random.nextDouble() * 0.5 - 0.25) * (double)buildupProgress, (random.nextDouble() * 0.5 - 0.25) * (double)buildupProgress);
        matrix.func_227860_a_();
        matrix.func_227863_a_(new Quaternion((float)MathHelper.func_151238_b((double)0.0, (double)-45.0, (double)progress), 0.0f, (float)MathHelper.func_151238_b((double)0.0, (double)(35.0f * handOffset), (double)progress), true));
        matrix.func_227861_a_((double)handOffset + MathHelper.func_151238_b((double)0.0, (double)offset.func_82615_a(), (double)partialTicks), -0.5 - (double)(progress / 5.0f) + MathHelper.func_151238_b((double)0.0, (double)offset.func_82617_b(), (double)partialTicks), -1.2 + MathHelper.func_151238_b((double)0.0, (double)offset.func_82616_c(), (double)partialTicks));
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void forwardWaving(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        float offset = hand == HandSide.RIGHT ? 1.0f : -1.0f;
        float maxForward = maxDuration > 20 ? 5.0f : (float)(maxDuration / 4);
        float forwardProgress = MathHelper.func_76131_a((float)(duration / maxForward), (float)0.0f, (float)1.0f);
        Vec3d forward = new Vec3d(MathHelper.func_151238_b((double)0.0, (double)-45.0, (double)forwardProgress), 0.0, MathHelper.func_151238_b((double)0.0, (double)(35.0f * offset), (double)forwardProgress));
        Vec3d waving = new Vec3d((double)(MathHelper.func_76134_b((float)(duration / 20.0f * (float)Math.PI * 2.0f)) * 10.0f), 0.0, (double)(MathHelper.func_76126_a((float)(duration / 20.0f * (float)Math.PI * 2.0f)) * 10.0f));
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, -0.5, 0.0);
        matrix.func_227863_a_(new Quaternion((float)(forward.field_72450_a + waving.field_72450_a), (float)waving.field_72448_b, (float)(forward.field_72449_c + waving.field_72449_c), true));
        matrix.func_227861_a_(0.0, 0.5, 0.0);
        matrix.func_227861_a_((double)offset, -0.5 - (double)(forwardProgress / 5.0f), -1.2);
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void circling(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, -1.0, 0.0);
        matrix.func_227863_a_(new Quaternion(MathHelper.func_76134_b((float)(duration / 10.0f * (float)Math.PI * 2.0f)) * 10.0f, 0.0f, MathHelper.func_76126_a((float)(duration / 10.0f * (float)Math.PI * 2.0f)) * 10.0f, true));
        matrix.func_227861_a_(0.0, 1.0, 0.0);
        matrix.func_227861_a_(hand == HandSide.RIGHT ? 1.0 : -1.0, -1.0, -1.2);
        renderer.func_228364_a_(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.func_227865_b_();
    }

    public static void noRender(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int combinedOverlayIn, float partialTicks, HandSide hand) {
    }

    @FunctionalInterface
    public static interface RenderFirstPersonMagic {
        public void render(WizardStaffTileEntityRenderer var1, float var2, int var3, ItemStack var4, MatrixStack var5, IRenderTypeBuffer var6, int var7, int var8, float var9, HandSide var10);
    }
}

