/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import javax.annotation.Nullable;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.capability.ScreenAnimations;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffCapabilityProvider;
import mod.vemerion.wizardstaff.staff.WizardStaffContainer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;

public class WizardStaffItem
extends Item {
    public WizardStaffItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78027_g).setISTER(() -> WizardStaffTileEntityRenderer::new));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_213453_ef()) {
            if (!worldIn.field_72995_K) {
                boolean shouldAnimate = ScreenAnimations.getScreenAnimations(playerIn).shouldAnimate();
                SimpleNamedContainerProvider provider = new SimpleNamedContainerProvider((id, inventory, player) -> new WizardStaffContainer(id, inventory, WizardStaffItemHandler.get(itemstack), itemstack, shouldAnimate), this.func_200295_i(itemstack));
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)provider, buffer -> buffer.writeBoolean(shouldAnimate));
            }
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        ItemStack magic = this.getMagic(itemstack);
        Magics.getInstance().get(magic).magicStart(worldIn, playerIn, itemstack);
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack == newStack;
    }

    public ItemStack getMagic(ItemStack itemstack) {
        return WizardStaffItemHandler.get(itemstack).getStackInSlot(0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new WizardStaffCapabilityProvider();
    }

    public UseAction func_77661_b(ItemStack stack) {
        ItemStack magic = this.getMagic(stack);
        return Magics.getInstance().get(magic).getUseAction(stack);
    }

    public int func_77626_a(ItemStack stack) {
        ItemStack magic = this.getMagic(stack);
        return Magics.getInstance().get(magic).getUseDuration(stack);
    }

    public void func_219972_a(World worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        ItemStack magic = this.getMagic(stack);
        if (livingEntityIn instanceof PlayerEntity) {
            Magics.getInstance().get(magic).magicTick(worldIn, (PlayerEntity)livingEntityIn, stack, count);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        ItemStack magic = this.getMagic(stack);
        if (entityLiving instanceof PlayerEntity) {
            return Magics.getInstance().get(magic).magicFinish(worldIn, (PlayerEntity)entityLiving, stack);
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        ItemStack magic = this.getMagic(stack);
        if (entityLiving instanceof PlayerEntity) {
            Magics.getInstance().get(magic).magicCancel(worldIn, (PlayerEntity)entityLiving, stack, timeLeft);
        }
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT result = new CompoundNBT();
        CompoundNBT tag = super.getShareTag(stack);
        CompoundNBT cap = WizardStaffItemHandler.get(stack).serializeNBT();
        if (tag != null) {
            result.func_218657_a("tag", (INBT)tag);
        }
        if (cap != null) {
            result.func_218657_a("cap", (INBT)cap);
        }
        return result;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null) {
            stack.func_77982_d(nbt);
        } else {
            stack.func_77982_d(nbt.func_74775_l("tag"));
            WizardStaffItemHandler.get(stack).deserializeNBT(nbt.func_74775_l("cap"));
        }
    }
}

