/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.netherupdate;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.capability.Wizard;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class LodestoneMagic
extends Magic {
    private Block waypoint;

    public LodestoneMagic(MagicType<? extends LodestoneMagic> type) {
        super(type);
    }

    public LodestoneMagic setAdditionalParams(Block waypoint) {
        this.waypoint = waypoint;
        return this;
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.waypoint = (Block)MagicUtil.decode(buffer, ForgeRegistries.BLOCKS);
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.waypoint);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.waypoint = (Block)MagicUtil.read(json, ForgeRegistries.BLOCKS, "waypoint");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.waypoint, "waypoint");
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.waypoint.func_235333_g_()};
    }

    @Override
    public ActionResultType magicInteractBlock(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (world.func_180495_p(context.func_195995_a()).func_177230_c() == this.waypoint) {
            player.func_184185_a(ModSounds.GONG, 1.0f, this.soundPitch(player));
            if (!world.field_72995_K) {
                Wizard.getWizard(player).trackLodestone(world, context.func_195995_a(), this.waypoint);
            }
            return ActionResultType.SUCCESS;
        }
        return super.magicInteractBlock(context);
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K && Wizard.getWizard(player).lodestoneTeleport((ServerPlayerEntity)player, this.waypoint)) {
            this.playSoundServer(world, player, ModSounds.GONG, 1.0f, this.soundPitch(player));
            this.cost(player);
        }
        return super.magicFinish(world, player, staff);
    }

    @Override
    public void magicTick(World world, PlayerEntity player, ItemStack staff, int count) {
        if (count % 10 == 0) {
            player.func_184185_a(ModSounds.TELEPORT, 1.0f, this.soundPitch(player));
        }
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::buildup;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.CROSSBOW;
    }
}

