/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.restructuring;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;

public class BuilderMagic
extends Magic {
    private ResourceLocation name;
    private Direction front;
    private BlockPos center;
    private BlockPos playerOffset;
    private static final IStructureProcessorType<AirStructureProcessor> AIR = (IStructureProcessorType)Registry.func_218322_a((Registry)Registry.field_218364_E, (ResourceLocation)new ResourceLocation("wizard-staff", "air"), () -> AirStructureProcessor.CODEC);

    public BuilderMagic(MagicType<? extends BuilderMagic> type) {
        super(type);
    }

    public BuilderMagic setAdditionalParams(ResourceLocation name, Direction front, BlockPos center, BlockPos playerOffset) {
        this.name = name;
        this.front = front;
        this.center = center;
        this.playerOffset = playerOffset;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"template"));
        String direction = JSONUtils.func_151200_h((JsonObject)json, (String)"front");
        this.front = Direction.func_176739_a((String)direction);
        if (this.front == null) {
            throw new JsonParseException("Invalid direction " + direction + " for front attribute");
        }
        if (!Direction.Plane.HORIZONTAL.test(this.front)) {
            throw new JsonParseException("Direction must be horizontal for front attribute");
        }
        this.center = MagicUtil.readBlockPos(json, "center");
        this.playerOffset = MagicUtil.readBlockPos(json, "player_offset");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("template", this.name.toString());
        json.addProperty("front", this.front.func_176742_j());
        MagicUtil.writeBlockPos(json, "center", this.center);
        MagicUtil.writeBlockPos(json, "player_offset", this.playerOffset);
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        int len = buffer.readInt();
        this.name = new ResourceLocation(buffer.func_150789_c(len));
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        buffer.writeInt(this.name.toString().length());
        buffer.func_180714_a(this.name.toString());
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{new StringTextComponent(this.name.func_110623_a())};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new StringTextComponent(this.name.func_110623_a())};
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::buildup;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K && this.generateStructure((ServerWorld)world, player)) {
            this.cost(player);
            this.playSoundServer(world, player, ModSounds.BUILDING, 1.0f, this.soundPitch(player));
        }
        return super.magicFinish(world, player, staff);
    }

    private boolean generateStructure(ServerWorld world, PlayerEntity player) {
        Template template = world.func_184163_y().func_200219_b(this.name);
        if (template == null) {
            Main.LOGGER.error("Invalid template name " + this.name);
            return false;
        }
        Direction direction = this.getDirection(player);
        BlockPos offset = BlockPos.field_177992_a.func_177967_a(direction, this.playerOffset.func_177952_p()).func_177967_a(direction.func_176746_e(), this.playerOffset.func_177958_n()).func_177967_a(Direction.UP, this.playerOffset.func_177956_o());
        BlockPos pos = player.func_233580_cy_().func_177973_b((Vector3i)new BlockPos(this.center.func_177958_n(), 0, this.center.func_177956_o())).func_177971_a((Vector3i)offset);
        Rotation rotation = this.calculateRotation(player);
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE).func_207665_a(this.center).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a).func_215222_a((StructureProcessor)AirStructureProcessor.INSTANCE);
        return template.func_237146_a_((IServerWorld)world, pos, pos, settings, player.func_70681_au(), 2);
    }

    private Rotation calculateRotation(PlayerEntity player) {
        Direction direction = this.getDirection(player).func_176734_d();
        if (this.front == direction) {
            return Rotation.NONE;
        }
        if (this.front == direction.func_176746_e()) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        if (this.front == direction.func_176735_f()) {
            return Rotation.CLOCKWISE_90;
        }
        return Rotation.CLOCKWISE_180;
    }

    private Direction getDirection(PlayerEntity player) {
        Direction[] directions;
        for (Direction d : directions = Direction.func_196054_a((Entity)player)) {
            if (!Direction.Plane.HORIZONTAL.test(d)) continue;
            return d;
        }
        return Direction.NORTH;
    }

    private static class AirStructureProcessor
    extends StructureProcessor {
        public static final AirStructureProcessor INSTANCE = new AirStructureProcessor();
        public static final Codec<AirStructureProcessor> CODEC = Codec.unit(() -> INSTANCE);

        private AirStructureProcessor() {
        }

        protected IStructureProcessorType<?> func_215192_a() {
            return AIR;
        }

        public Template.BlockInfo process(IWorldReader world, BlockPos center1, BlockPos center2, Template.BlockInfo infoRelative, Template.BlockInfo infoAbsolute, PlacementSettings settings, Template template) {
            return !world.func_175623_d(infoAbsolute.field_186242_a) ? null : super.process(world, center1, center2, infoRelative, infoAbsolute, settings, template);
        }
    }
}

