/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.spellbookupdate;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class MapMagic
extends Magic {
    private static final ImmutableList<StructureInfo> VALID_STRUCTURES = ImmutableList.of((Object)new StructureInfo(Structure.field_236381_q_, MapDecoration.Type.MANSION));

    public MapMagic(MagicType<? extends MapMagic> type) {
        super(type);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::buildup;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K) {
            ServerWorld serverworld = (ServerWorld)world;
            StructureInfo structureInfo = (StructureInfo)VALID_STRUCTURES.get(player.func_70681_au().nextInt(VALID_STRUCTURES.size()));
            BlockPos pos = serverworld.func_241117_a_(structureInfo.structure, this.randPos(player), 2, true);
            if (pos != null) {
                this.cost(player);
                this.playSoundServer(world, player, ModSounds.SCRIBBLE, 1.0f, this.soundPitch(player));
                ItemStack map = FilledMapItem.func_195952_a((World)serverworld, (int)pos.func_177958_n(), (int)pos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)map);
                MapData.func_191094_a((ItemStack)map, (BlockPos)pos, (String)"+", (MapDecoration.Type)structureInfo.decoration);
                map.func_200302_a(Items.field_151098_aY.func_200296_o());
                WizardStaffItemHandler handler = WizardStaffItem.getHandler(staff);
                handler.extractItem(0, 1, false);
                handler.insertItem(0, map, false);
            } else {
                this.playSoundServer(world, player, SoundEvents.field_187541_bC, 1.0f, this.soundPitch(player));
            }
        }
        return super.magicFinish(world, player, staff);
    }

    private BlockPos randPos(PlayerEntity player) {
        Random rand = player.func_70681_au();
        return player.func_233580_cy_().func_177982_a(rand.nextInt(1000) - 500, rand.nextInt(1000) - 500, rand.nextInt(1000) - 500);
    }

    private static class StructureInfo {
        private Structure<?> structure;
        private MapDecoration.Type decoration;

        private StructureInfo(Structure<?> structure, MapDecoration.Type decoration) {
            this.structure = structure;
            this.decoration = decoration;
        }
    }
}

